/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.wbtest.selenium;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.uberfire.wbtest.client.main.DefaultPerspectiveActivity;
import org.uberfire.wbtest.client.splash.HasJsSplashOne;
import org.uberfire.wbtest.client.splash.HasJsSplashTwo;
import org.uberfire.wbtest.client.splash.SplashyPerspective;
import org.uberfire.wbtest.client.splash.SplashyPerspectiveSplashScreen;
import org.uberfire.wbtest.client.splash.SplashyScreen;
import org.uberfire.wbtest.client.splash.SplashyScreenSplashScreen;
import org.uberfire.wbtest.selenium.AbstractSeleniumTest;
import org.uberfire.wbtest.selenium.SplashListWrapper;

public class SplashScreenTest
extends AbstractSeleniumTest {
    @Test
    public void splashScreenShouldShowEveryTimeWhenNavigatingToInterceptedPerspective() throws Exception {
        this.driver.get(this.baseUrl + "#" + SplashyPerspective.class.getName() + "?debugId=1");
        WebElement splashLabel = this.driver.findElement(By.id((String)"SplashyPerspectiveSplashScreen-1"));
        this.waitUntilDisplayed(5000, splashLabel);
        this.driver.findElement(By.id((String)"gwt-debug-SplashModalFooter-close")).click();
        this.waitUntilGone(5000, By.id((String)"SplashyPerspectiveSplashScreen-1"));
        this.driver.get(this.baseUrl + "#" + DefaultPerspectiveActivity.class.getName());
        this.waitForDefaultPerspective();
        this.driver.get(this.baseUrl + "#" + SplashyPerspective.class.getName() + "?debugId=2");
        splashLabel = this.driver.findElement(By.id((String)"SplashyPerspectiveSplashScreen-2"));
        this.waitUntilDisplayed(5000, splashLabel);
        this.driver.findElement(By.id((String)"gwt-debug-SplashModalFooter-close")).click();
        this.waitUntilGone(5000, By.id((String)"SplashyPerspectiveSplashScreen-2"));
    }

    @Test
    public void splashScreenShouldNotShowAgainAfterPreferenceChanged() throws Exception {
        this.driver.get(this.baseUrl + "#" + SplashyPerspective.class.getName() + "?debugId=1");
        WebElement splashLabel = this.driver.findElement(By.id((String)"SplashyPerspectiveSplashScreen-1"));
        this.waitUntilDisplayed(5000, splashLabel);
        this.driver.findElement(By.id((String)"gwt-debug-SplashModalFooter-dontShowAgain-input")).click();
        this.driver.findElement(By.id((String)"gwt-debug-SplashModalFooter-close")).click();
        this.waitUntilGone(5000, By.id((String)"SplashyPerspectiveSplashScreen-1"));
        this.driver.get(this.baseUrl + "#" + DefaultPerspectiveActivity.class.getName());
        this.waitForDefaultPerspective();
        this.driver.get(this.baseUrl + "#" + SplashyPerspective.class.getName() + "?debugId=2");
        this.driver.manage().timeouts().implicitlyWait(5000L, TimeUnit.MILLISECONDS);
        List splashLabels = this.driver.findElements(By.id((String)"SplashyPerspectiveSplashScreen-2"));
        Assert.assertEquals((long)0L, (long)splashLabels.size());
    }

    @Test
    public void splashListShouldStayUpToDate() throws Exception {
        this.driver.get(this.baseUrl + "#" + SplashyPerspective.class.getName() + "?debugId=1");
        WebElement perspectiveSplashLabel = this.driver.findElement(By.id((String)"SplashyPerspectiveSplashScreen-1"));
        this.waitUntilDisplayed(5000, perspectiveSplashLabel);
        this.driver.findElement(By.id((String)"gwt-debug-SplashModalFooter-close")).click();
        this.waitUntilGone(5000, By.id((String)"SplashyPerspectiveSplashScreen-1"));
        this.driver.get(this.baseUrl + "#" + HasJsSplashOne.class.getName());
        WebElement jsSplashScreenSplashLabel = this.driver.findElement(By.id((String)"js-splash-one"));
        this.waitUntilDisplayed(5000, jsSplashScreenSplashLabel);
        this.driver.findElement(By.id((String)"gwt-debug-SplashModalFooter-close")).click();
        this.waitUntilGone(5000, By.id((String)"js-splash-one"));
        this.driver.get(this.baseUrl + "#" + SplashyScreen.class.getName() + "?debugId=1");
        WebElement screenSplashLabel = this.driver.findElement(By.id((String)"SplashyScreenSplashScreen-1"));
        this.waitUntilDisplayed(5000, screenSplashLabel);
        this.driver.findElement(By.id((String)"gwt-debug-SplashModalFooter-close")).click();
        this.waitUntilGone(5000, By.id((String)"SplashyScreenSplashScreen-1"));
        SplashListWrapper splashList = new SplashListWrapper(this.driver, "SplashyScreen-1-SplashList");
        List<String> contents = splashList.getContents();
        Assert.assertTrue((boolean)contents.contains(SplashyPerspectiveSplashScreen.class.getName()));
        Assert.assertTrue((boolean)contents.contains("Splash One"));
        Assert.assertTrue((boolean)contents.contains(SplashyScreenSplashScreen.class.getName()));
        Assert.assertEquals((long)3L, (long)contents.size());
    }

    @Test
    public void activitiesWithJsSplashScreensShouldClose() throws Exception {
        this.driver.get(this.baseUrl + "#" + SplashyPerspective.class.getName() + "?debugId=1");
        WebElement perspectiveSplashLabel = this.driver.findElement(By.id((String)"SplashyPerspectiveSplashScreen-1"));
        this.waitUntilDisplayed(5000, perspectiveSplashLabel);
        this.driver.findElement(By.id((String)"gwt-debug-SplashModalFooter-close")).click();
        this.waitUntilGone(5000, By.id((String)"SplashyPerspectiveSplashScreen-1"));
        this.driver.get(this.baseUrl + "#" + HasJsSplashOne.class.getName());
        WebElement jsSplashScreenSplashLabel = this.driver.findElement(By.id((String)"js-splash-one"));
        this.waitUntilDisplayed(5000, jsSplashScreenSplashLabel);
        this.driver.findElement(By.id((String)"gwt-debug-SplashModalFooter-close")).click();
        this.waitUntilGone(5000, By.id((String)"js-splash-one"));
        this.driver.get(this.baseUrl + "#" + HasJsSplashTwo.class.getName());
        WebElement screenSplashLabel = this.driver.findElement(By.id((String)"js-splash-two"));
        this.waitUntilDisplayed(5000, screenSplashLabel);
        this.driver.findElement(By.id((String)"gwt-debug-SplashModalFooter-close")).click();
        this.waitUntilGone(5000, By.id((String)"js-splash-two"));
        WebElement activeTab = this.driver.findElement(By.cssSelector((String)"ul.nav-tabs li.active"));
        WebElement tabCloseButton = activeTab.findElement(By.className((String)"close"));
        tabCloseButton.click();
        this.waitUntilGone(2000, By.id((String)"HasJsSplashTwo"));
    }

    protected void waitUntilDisplayed(int timeoutMillis, WebElement checkMe) throws InterruptedException {
        long deadline = System.currentTimeMillis() + (long)timeoutMillis;
        while (System.currentTimeMillis() < deadline) {
            if (checkMe.isDisplayed()) {
                return;
            }
            Thread.sleep(500L);
        }
        Assert.fail((String)("Element still not visible after " + timeoutMillis + "ms: " + checkMe));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilGone(int timeoutMillis, By findBy) throws InterruptedException {
        try {
            this.driver.manage().timeouts().implicitlyWait(100L, TimeUnit.MILLISECONDS);
            long deadline = System.currentTimeMillis() + (long)timeoutMillis;
            while (System.currentTimeMillis() < deadline) {
                if (this.driver.findElements(findBy).size() == 0) {
                    return;
                }
                Thread.sleep(500L);
            }
            Assert.fail((String)("Element still present after " + timeoutMillis + "ms"));
        }
        finally {
            this.setNormalTimeout();
        }
    }
}

