/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.wbtest.selenium;

import java.util.List;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.uberfire.wbtest.selenium.AbstractWorkbenchPanelWrapper;

public class MultiTabPanelWrapper
extends AbstractWorkbenchPanelWrapper {
    public MultiTabPanelWrapper(WebDriver driver, String panelId) {
        super(driver, panelId);
    }

    public List<WebElement> getNonNestedTabs() {
        return this.driver.findElements(By.cssSelector((String)".nav.nav-tabs > li"));
    }

    public List<WebElement> getNestedTabs() {
        return this.driver.findElements(By.cssSelector((String)".dropdown-menu > li"));
    }

    public WebElement getDropdownTab() {
        List dropdowns = this.driver.findElements(By.cssSelector((String)".nav.nav-tabs > li.dropdown"));
        if (dropdowns.isEmpty()) {
            return null;
        }
        if (dropdowns.size() > 1) {
            Assert.fail((String)("Found too many dropdown tabs: " + dropdowns));
        }
        return (WebElement)dropdowns.get(0);
    }

    public String getDropdownTabLabel() {
        WebElement dropdownTab = this.getDropdownTab();
        return dropdownTab.findElement(By.cssSelector((String)"a.dropdown-toggle")).getText();
    }

    public WebElement getSelectedTab() {
        WebElement foundTab = null;
        for (WebElement selectedTab : this.driver.findElements(By.cssSelector((String)"li.active"))) {
            if (selectedTab.getAttribute("class").contains("dropdown")) continue;
            if (foundTab != null) {
                Assert.fail((String)("Too many selected tabs! Found \"" + foundTab.getText() + "\" and \"" + selectedTab.getText() + "\""));
            }
            foundTab = selectedTab;
        }
        return foundTab;
    }

    public String getSelectedTabLabel() throws InterruptedException {
        WebElement selectedTab = this.getSelectedTab();
        if (selectedTab == null) {
            return null;
        }
        WebElement dropdownTab = this.getDropdownTab();
        if (dropdownTab != null) {
            dropdownTab.findElement(By.tagName((String)"a")).click();
        }
        String allText = selectedTab.findElement(By.tagName((String)"a")).getText();
        String buttonText = selectedTab.findElement(By.tagName((String)"button")).getText();
        if (dropdownTab != null) {
            dropdownTab.click();
        }
        return allText.substring(0, allText.indexOf(buttonText)).trim();
    }

    public void closeSelectedTab() {
        WebElement selectedTab = this.getSelectedTab();
        if (selectedTab == null) {
            Assert.fail((String)"No tab is selected");
        }
        selectedTab.findElement(By.tagName((String)"button")).click();
    }

    public void closeTab(String label) {
        WebElement tab = this.driver.findElement(By.partialLinkText((String)label));
        tab.findElement(By.tagName((String)"button")).click();
    }
}

