/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.bs2.maximize;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import org.uberfire.client.resources.i18n.WorkbenchConstants;
import org.uberfire.client.workbench.panels.MaximizeToggleButtonPresenter;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.mvp.Command;

public class MaximizeToggleButton
extends Button
implements MaximizeToggleButtonPresenter.View {
    private MaximizeToggleButtonPresenter presenter;
    private boolean maximized;
    private Command maximizeCommand;
    private Command unmaximizeCommand;

    public MaximizeToggleButton() {
        this.setIcon(IconType.CHEVRON_UP);
        this.setIconSize(IconSize.SMALL);
        this.setSize(ButtonSize.MINI);
        this.setTitle(WorkbenchConstants.INSTANCE.maximizePanel());
        this.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                MaximizeToggleButton.this.presenter.handleClick();
            }
        });
    }

    public void init(MaximizeToggleButtonPresenter presenter) {
        this.presenter = (MaximizeToggleButtonPresenter)PortablePreconditions.checkNotNull((String)"presenter", (Object)presenter);
    }

    public void click() {
        boolean wasMaximized = this.maximized;
        this.setMaximized(!wasMaximized);
        if (wasMaximized) {
            if (this.unmaximizeCommand != null) {
                this.unmaximizeCommand.execute();
                this.setTitle(WorkbenchConstants.INSTANCE.maximizePanel());
            }
        } else if (this.maximizeCommand != null) {
            this.maximizeCommand.execute();
            this.setTitle(WorkbenchConstants.INSTANCE.minimizePanel());
        }
    }

    public Command getMaximizeCommand() {
        return this.maximizeCommand;
    }

    public void setMaximizeCommand(Command maximizeCommand) {
        this.maximizeCommand = maximizeCommand;
    }

    public Command getUnmaximizeCommand() {
        return this.unmaximizeCommand;
    }

    public void setUnmaximizeCommand(Command unmaximizeCommand) {
        this.unmaximizeCommand = unmaximizeCommand;
    }

    public boolean isMaximized() {
        return this.maximized;
    }

    public void setMaximized(boolean maximized) {
        this.maximized = maximized;
        if (maximized) {
            this.setIcon(IconType.CHEVRON_DOWN);
            this.setTitle(WorkbenchConstants.INSTANCE.minimizePanel());
        } else {
            this.setIcon(IconType.CHEVRON_UP);
            this.setTitle(WorkbenchConstants.INSTANCE.maximizePanel());
        }
    }
}

