/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.bs2.menu;

import com.github.gwtbootstrap.client.ui.NavPills;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.bs2.menu.MenusFixture;
import org.uberfire.client.views.bs2.menu.PespectiveContextMenusView;
import org.uberfire.client.views.bs2.menu.PespectiveMenusViewUnitTestWrapper;
import org.uberfire.workbench.model.menu.MenuGroup;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuItemCommand;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=GwtMockitoTestRunner.class)
public class PespectiveContextMenusViewTest {
    private PespectiveMenusViewUnitTestWrapper pespectiveMenusViewUnitTestWrapper;
    private PespectiveContextMenusView pespectiveContextMenusViewWithoutPermission;
    private NavPills menuBar;
    private Menus menuTopLevel;

    @Before
    public void setup() {
        this.menuBar = (NavPills)GWT.create(NavPills.class);
        this.menuTopLevel = MenusFixture.buildTopLevelMenu();
        this.pespectiveMenusViewUnitTestWrapper = new PespectiveMenusViewUnitTestWrapper();
        this.pespectiveMenusViewUnitTestWrapper.setupMocks(this.menuBar);
        this.pespectiveContextMenusViewWithoutPermission = new PespectiveContextMenusView(){

            boolean notHavePermissionToMakeThis(MenuItem item) {
                return true;
            }
        };
    }

    @Test
    public void simpleAddMenuItems() {
        Menus item = MenusFixture.buildMenuGroup();
        this.pespectiveMenusViewUnitTestWrapper.buildMenu(item);
        ((NavPills)Mockito.verify((Object)this.menuBar, (VerificationMode)Mockito.times((int)item.getItems().size()))).add((Widget)Mockito.any(Widget.class));
    }

    @Test
    public void makeItemWithoutPermissionShouldReturnNull() {
        Assert.assertNull((Object)this.pespectiveContextMenusViewWithoutPermission.makeItem((MenuItem)this.menuTopLevel.getItems().get(0)));
    }

    @Test
    public void makeMenuItemCommand() {
        PespectiveMenusViewUnitTestWrapper spy = (PespectiveMenusViewUnitTestWrapper)((Object)Mockito.spy((Object)((Object)this.pespectiveMenusViewUnitTestWrapper)));
        MenuItemCommand item = MenusFixture.buildMenuItemCommand();
        Widget widget = spy.makeItem((MenuItem)item);
        ((PespectiveMenusViewUnitTestWrapper)((Object)Mockito.verify((Object)((Object)spy), (VerificationMode)Mockito.times((int)1)))).makeMenuItemCommand((MenuItem)item);
    }

    @Test
    public void makeMenuGroup() {
        PespectiveMenusViewUnitTestWrapper spy = (PespectiveMenusViewUnitTestWrapper)((Object)Mockito.spy((Object)((Object)this.pespectiveMenusViewUnitTestWrapper)));
        MenuItem item = MenusFixture.buildMenuGroupItem();
        Widget widget = spy.makeItem(item);
        ((PespectiveMenusViewUnitTestWrapper)((Object)Mockito.verify((Object)((Object)spy), (VerificationMode)Mockito.times((int)1)))).makeMenuGroup((MenuGroup)item);
    }

    @Test
    public void otherTypesOfMenusShouldReturnNull() {
        Menus item = MenusFixture.buildTopLevelMenu();
        this.pespectiveMenusViewUnitTestWrapper.buildMenu(item);
        ((NavPills)Mockito.verify((Object)this.menuBar, (VerificationMode)Mockito.never())).add((Widget)Mockito.any(Widget.class));
    }
}

