/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.bs2.tab;

import com.github.gwtbootstrap.client.ui.Tab;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.views.bs2.tab.UberTabPanelUnitTestWrapper;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchDragAndDropManager;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;

@RunWith(value=GwtMockitoTestRunner.class)
public class UberTabPanelTest {
    private UberTabPanelUnitTestWrapper uberTabPanel;
    private WorkbenchPartPresenter partPresenter;
    private WorkbenchPartPresenter.View partView;
    private PartDefinition partDef;
    @GwtMock
    private WorkbenchDragAndDropManager dndManager;
    @Mock
    private PanelManager panelManager;

    @Before
    public void setup() {
        this.uberTabPanel = new UberTabPanelUnitTestWrapper(this.panelManager);
        this.uberTabPanel.setupMocks(this.dndManager);
        this.partView = (WorkbenchPartPresenter.View)GWT.create(WorkbenchPartPresenter.View.class);
        this.partDef = new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("SomeWorkbenchScreen"));
        this.partPresenter = (WorkbenchPartPresenter)Mockito.mock(WorkbenchPartPresenter.class);
        Mockito.when((Object)this.partView.getPresenter()).thenReturn((Object)this.partPresenter);
        Mockito.when((Object)this.partPresenter.getDefinition()).thenReturn((Object)this.partDef);
    }

    @Test
    public void assertInstanciationSequence() {
        Assert.assertNotNull((Object)this.uberTabPanel.tabPanel);
    }

    @Test
    public void createTabTest() {
        Tab tab = this.uberTabPanel.createTab(this.partView, true, 1, 1);
        ((Tab)Mockito.verify((Object)tab)).addClickHandler((ClickHandler)Mockito.any(ClickHandler.class));
        ((Tab)Mockito.verify((Object)tab)).add((Widget)Mockito.any(Widget.class));
        Assert.assertEquals((Object)tab.asTabLink(), this.uberTabPanel.tabIndex.get(this.partView));
        Assert.assertEquals((Object)this.partView, this.uberTabPanel.tabInvertedIndex.get(tab.asTabLink()));
        ((WorkbenchDragAndDropManager)Mockito.verify((Object)this.dndManager)).makeDraggable((IsWidget)Mockito.any(WorkbenchPartPresenter.View.class), (IsWidget)Mockito.any(Widget.class));
        Class<Widget> closeButtom = Widget.class;
        ((Tab)Mockito.verify((Object)tab)).addDecorate((Widget)Mockito.any(closeButtom));
    }

    @Test
    public void shouldFireFocusEventWhenClickedWhenUnfocused() throws Exception {
        this.uberTabPanel.setFocus(false);
        final int[] focusEventCount = new int[1];
        this.uberTabPanel.addOnFocusHandler(new Command(){

            public void execute() {
                focusEventCount[0] = focusEventCount[0] + 1;
            }
        });
        this.uberTabPanel.onClick((ClickEvent)Mockito.mock(ClickEvent.class));
        Assert.assertEquals((long)1L, (long)focusEventCount[0]);
    }
}

