/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.bs2.menu;

import com.github.gwtbootstrap.client.ui.Divider;
import com.github.gwtbootstrap.client.ui.NavLink;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.mockito.Mockito;
import org.uberfire.client.views.bs2.context.ContextDropdownButton;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.EnabledStateChangeListener;
import org.uberfire.workbench.model.menu.MenuCustom;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuItemCommand;
import org.uberfire.workbench.model.menu.MenuPosition;
import org.uberfire.workbench.model.menu.MenuVisitor;
import org.uberfire.workbench.model.menu.Menus;

public class MenusFixture {
    public static Menus buildTopLevelMenu() {
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.SubMenuBuilder)((MenuFactory.MenuBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.SubMenuBuilder)((MenuFactory.MenuBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.SubMenuBuilder)((MenuFactory.MenuBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.SubMenuBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)"RIGHT").position(MenuPosition.RIGHT)).menus().endMenus()).endMenu()).newTopLevelMenu("CENTER").position(MenuPosition.CENTER)).menus().endMenus()).endMenu()).newTopLevelMenu("LEFT").position(MenuPosition.LEFT)).menus().endMenus()).endMenu()).newTopLevelMenu("RIGHT").position(MenuPosition.RIGHT)).menus().endMenus()).endMenu()).build();
    }

    public static MenuItem buildCustomMenu() {
        Menus menu = ((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new MenuCustom<Widget>(){

                    public Widget build() {
                        return new ContextDropdownButton(){
                            {
                                this.displayCaret(false);
                                this.setRightDropdown(true);
                                this.setIcon(IconType.COG);
                                this.setSize(ButtonSize.MINI);
                                this.add((Widget)new NavLink("Business view"){
                                    {
                                        this.setIconSize(IconSize.SMALL);
                                    }
                                });
                                this.add((Widget)new NavLink("Tech view"){
                                    {
                                        this.setIcon(IconType.ASTERISK);
                                        this.setIconSize(IconSize.SMALL);
                                    }
                                });
                                this.add((Widget)new Divider());
                                this.add((Widget)new NavLink("Breadbrumb Explorer"){
                                    {
                                        this.setIcon(IconType.OK);
                                        this.setIconSize(IconSize.SMALL);
                                    }
                                });
                                this.add((Widget)new NavLink("Tree explorer"){});
                                this.add((Widget)new Divider());
                                this.add((Widget)new NavLink("Flatten folders"){});
                                this.add((Widget)new NavLink("Compact empty folders"){});
                                this.add((Widget)new NavLink("Display hidden files"){});
                            }
                        };
                    }

                    public boolean isEnabled() {
                        return false;
                    }

                    public void setEnabled(boolean enabled) {
                    }

                    public String getContributionPoint() {
                        return null;
                    }

                    public String getCaption() {
                        return null;
                    }

                    public MenuPosition getPosition() {
                        return null;
                    }

                    public int getOrder() {
                        return 0;
                    }

                    public void addEnabledStateChangeListener(EnabledStateChangeListener listener) {
                    }

                    public String getSignatureId() {
                        return null;
                    }

                    public Collection<String> getRoles() {
                        return null;
                    }

                    public Collection<String> getTraits() {
                        return null;
                    }

                    public void accept(MenuVisitor visitor) {
                        visitor.visit((MenuCustom)this);
                    }
                };
            }
        }).endMenu()).build();
        return (MenuItem)menu.getItems().get(0);
    }

    public static MenuItem buildMenuGroupItem() {
        Menus menu = MenusFixture.buildMenuGroup();
        return (MenuItem)menu.getItems().get(0);
    }

    public static Menus buildMenuGroup() {
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.SubMenuBuilder)((MenuFactory.SubMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.SubMenuBuilder)((MenuFactory.SubMenusBuilder)((MenuFactory.SubMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.SubMenuBuilder)((MenuFactory.SubMenusBuilder)((MenuFactory.SubMenusBuilder)MenuFactory.newTopLevelMenu((String)"Screens").menus().menu("Hello Screen").endMenu()).menu("Mood Screen").endMenu()).endMenus()).endMenu()).newTopLevelMenu("Perspectives").menus().menu("Home Perspective").endMenu()).menu("Horizontal Perspective").endMenu()).endMenus()).endMenu()).newTopLevelMenu("Other").menus().menu("Alert Box").endMenu()).endMenus()).endMenu()).build();
    }

    public static MenuItemCommand buildMenuItemCommand() {
        return new MenuItemCommand(){
            private final List<EnabledStateChangeListener> enabledStateChangeListeners = new ArrayList<EnabledStateChangeListener>();
            private boolean isEnabled = true;

            public Command getCommand() {
                return (Command)Mockito.mock(Command.class);
            }

            public String getContributionPoint() {
                return "";
            }

            public String getCaption() {
                return "";
            }

            public MenuPosition getPosition() {
                return (MenuPosition)Mockito.mock(MenuPosition.class);
            }

            public int getOrder() {
                return 1;
            }

            public boolean isEnabled() {
                return this.isEnabled;
            }

            public void setEnabled(boolean enabled) {
                this.isEnabled = enabled;
                this.notifyListeners(enabled);
            }

            public void addEnabledStateChangeListener(EnabledStateChangeListener listener) {
                this.enabledStateChangeListeners.add(listener);
            }

            public String getSignatureId() {
                return "";
            }

            public Collection<String> getRoles() {
                return (Collection)Mockito.mock(Collection.class);
            }

            public Collection<String> getTraits() {
                return Collections.emptyList();
            }

            public void accept(MenuVisitor visitor) {
                visitor.visit((MenuItemCommand)this);
            }

            private void notifyListeners(boolean enabled) {
                for (EnabledStateChangeListener listener : this.enabledStateChangeListeners) {
                    listener.enabledStateChanged(enabled);
                }
            }
        };
    }
}

