/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.bs2.toolbar;

import com.github.gwtbootstrap.client.ui.ButtonGroup;
import com.github.gwtbootstrap.client.ui.ButtonToolbar;
import com.github.gwtbootstrap.client.ui.Tooltip;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.constants.Placement;
import com.google.gwt.animation.client.Animation;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.uberfire.client.resources.i18n.WorkbenchConstants;
import org.uberfire.client.workbench.widgets.toolbar.WorkbenchToolBarPresenter;
import org.uberfire.workbench.model.toolbar.ToolBar;
import org.uberfire.workbench.model.toolbar.ToolBarItem;
import org.uberfire.workbench.model.toolbar.ToolBarTypeIcon;

public class WorkbenchToolBarView
extends Composite
implements WorkbenchToolBarPresenter.View {
    private static WorkbenchToolBarViewBinder uiBinder = (WorkbenchToolBarViewBinder)GWT.create(WorkbenchToolBarViewBinder.class);
    @UiField
    public FlowPanel masterContainer;
    @UiField
    public FlowPanel container;
    @UiField
    public ButtonToolbar toolBar;
    @UiField
    public SimplePanel simpleMargin;
    @UiField
    public Button viewControl;
    @UiField
    public Tooltip tip;
    private State state = State.EXPANDED;
    private final Map<String, ButtonGroup> toolBarItemsMap = new HashMap<String, ButtonGroup>();

    public WorkbenchToolBarView() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.tip.setText(WorkbenchConstants.INSTANCE.collapseToolbar());
        this.tip.setPlacement(Placement.LEFT);
        this.tip.setWidget((Widget)this.viewControl);
        this.simpleMargin.setVisible(false);
    }

    public void addToolBar(ToolBar _toolBar) {
        ButtonGroup bgroup = new ButtonGroup();
        if (this.toolBarItemsMap.size() == 0) {
            bgroup.getElement().getStyle().setPaddingLeft(19.0, Style.Unit.PX);
        }
        for (final ToolBarItem item : _toolBar.getItems()) {
            bgroup.add((IsWidget)new Tooltip(item.getTooltip()){
                {
                    super(x0);
                    this.setPlacement(Placement.BOTTOM);
                    this.add((Widget)new com.github.gwtbootstrap.client.ui.Button(){
                        {
                            this.setIcon(IconType.valueOf((String)((ToolBarTypeIcon)item.getIcon()).getType().toString()));
                            this.setEnabled(item.isEnabled());
                            this.addClickHandler(new ClickHandler(){

                                public void onClick(ClickEvent event) {
                                    item.getCommand().execute();
                                }
                            });
                        }
                    });
                }
            });
        }
        this.toolBarItemsMap.put(_toolBar.getId(), bgroup);
        this.toolBar.add((Widget)bgroup);
    }

    public void removeToolBar(ToolBar _toolBar) {
        this.toolBar.remove((Widget)this.toolBarItemsMap.remove(_toolBar.getId()));
    }

    public int getHeight() {
        if (this.isExpanded()) {
            return this.getOffsetHeight();
        }
        return 0;
    }

    private boolean isExpanded() {
        return this.state == State.EXPANDED;
    }

    public void hide() {
        this.container.setVisible(false);
        this.simpleMargin.setVisible(true);
    }

    public void show() {
        this.container.setVisible(true);
        this.simpleMargin.setVisible(false);
    }

    @UiHandler(value={"viewControl"})
    void handleClick(ClickEvent e) {
        if (this.isExpanded()) {
            this.collapse();
        } else {
            this.expand();
        }
    }

    private void expand() {
        this.container.removeFromParent();
        this.container.getElement().getStyle().clearTop();
        this.container.getElement().getStyle().clearPosition();
        this.container.getElement().getStyle().clearZIndex();
        this.masterContainer.add((Widget)this.container);
        this.tip.setText(WorkbenchConstants.INSTANCE.collapseToolbar());
        this.tip.setPlacement(Placement.LEFT);
        this.tip.setWidget((Widget)this.viewControl);
        this.tip.reconfigure();
        new ExpandAnimation().animate(8, this.getOffsetWidth() - 1, 500);
        this.state = State.EXPANDED;
    }

    private void collapse() {
        new CollapseAnimation().animate(this.getOffsetWidth(), 8, 500);
        this.container.removeFromParent();
        this.container.getElement().getStyle().setTop((double)this.getAbsoluteTop(), Style.Unit.PX);
        this.container.getElement().getStyle().setPosition(Style.Position.FIXED);
        this.container.getElement().getStyle().setZIndex(Integer.MAX_VALUE);
        RootPanel.get().add((Widget)this.container);
        this.tip.setText(WorkbenchConstants.INSTANCE.expandToolbar());
        this.tip.setPlacement(Placement.RIGHT);
        this.tip.setWidget((Widget)this.viewControl);
        this.tip.reconfigure();
        this.state = State.COLLAPSED;
    }

    private class CollapseAnimation
    extends Animation {
        private int endSize;
        private int startSize;

        private CollapseAnimation() {
        }

        protected void onComplete() {
            WorkbenchToolBarView.this.container.setWidth(null);
        }

        protected void onUpdate(double progress) {
            double delta = (double)(this.endSize - this.startSize) * progress;
            double newSize = (double)this.startSize + delta;
            WorkbenchToolBarView.this.toolBar.getElement().getStyle().setLeft(delta, Style.Unit.PX);
            WorkbenchToolBarView.this.container.setWidth(newSize + "px");
        }

        void animate(int startSize, int endSize, int duration) {
            this.startSize = startSize;
            this.endSize = endSize;
            this.run(duration);
        }
    }

    private class ExpandAnimation
    extends Animation {
        private int endSize;
        private int startSize;
        private int startTabLeft;
        private int endTabLeft;

        private ExpandAnimation() {
        }

        protected void onComplete() {
            WorkbenchToolBarView.this.toolBar.getElement().getStyle().clearLeft();
            WorkbenchToolBarView.this.container.getElement().getStyle().clearWidth();
        }

        protected void onUpdate(double progress) {
            double delta = (double)(this.endSize - this.startSize) * progress;
            double newSize = (double)this.startSize + delta;
            double deltaLeft = (double)(this.endTabLeft - this.startTabLeft) * progress;
            double newLeft = (double)this.startTabLeft + deltaLeft;
            WorkbenchToolBarView.this.toolBar.getElement().getStyle().setLeft(newLeft, Style.Unit.PX);
            WorkbenchToolBarView.this.container.setWidth(newSize + "px");
        }

        void animate(int startSize, int endSize, int duration) {
            this.startSize = startSize;
            this.endSize = endSize;
            this.startTabLeft = WorkbenchToolBarView.this.toolBar.getAbsoluteLeft();
            this.endTabLeft = 0;
            this.run(duration);
        }
    }

    static enum State {
        EXPANDED,
        COLLAPSED;

    }

    static interface WorkbenchToolBarViewBinder
    extends UiBinder<Panel, WorkbenchToolBarView> {
    }
}

