/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.bs2.menu;

import com.github.gwtbootstrap.client.ui.Nav;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.bs2.menu.MenusFixture;
import org.uberfire.client.views.bs2.menu.WorkbenchMenuBarView;
import org.uberfire.client.views.bs2.menu.WorkbenchMenuBarViewUnitTestWrapper;
import org.uberfire.workbench.model.menu.MenuCustom;
import org.uberfire.workbench.model.menu.MenuGroup;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuItemCommand;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=GwtMockitoTestRunner.class)
public class WorkbenchMenuBarViewTest {
    private WorkbenchMenuBarViewUnitTestWrapper workbenchMenuBarViewUnitTestWrapper;
    private WorkbenchMenuBarView workbenchMenuBarViewWithoutPermission;
    public Nav menuBarLeft;
    public Nav menuBarCenter;
    public Nav menuBarRight;
    private Menus menuTopLevel;

    @Before
    public void setup() {
        this.menuBarLeft = (Nav)GWT.create(Nav.class);
        this.menuBarCenter = (Nav)GWT.create(Nav.class);
        this.menuBarRight = (Nav)GWT.create(Nav.class);
        this.menuTopLevel = MenusFixture.buildTopLevelMenu();
        this.workbenchMenuBarViewUnitTestWrapper = new WorkbenchMenuBarViewUnitTestWrapper();
        this.workbenchMenuBarViewUnitTestWrapper.setupMocks(this.menuBarLeft, this.menuBarCenter, this.menuBarRight);
        this.workbenchMenuBarViewWithoutPermission = new WorkbenchMenuBarView(){

            boolean notHavePermissionToMakeThis(MenuItem item) {
                return true;
            }
        };
    }

    @Test
    public void simpleAddMenuItems() {
        this.workbenchMenuBarViewUnitTestWrapper.addMenuItems(this.menuTopLevel);
        ((Nav)Mockito.verify((Object)this.menuBarLeft, (VerificationMode)Mockito.times((int)1))).add((Widget)Mockito.any(Widget.class));
        ((Nav)Mockito.verify((Object)this.menuBarCenter, (VerificationMode)Mockito.times((int)1))).add((Widget)Mockito.any(Widget.class));
        ((Nav)Mockito.verify((Object)this.menuBarRight, (VerificationMode)Mockito.times((int)2))).add((Widget)Mockito.any(Widget.class));
    }

    @Test
    public void makeItemWithoutPermissionShouldReturnNull() {
        Assert.assertNull((Object)this.workbenchMenuBarViewWithoutPermission.makeItem((MenuItem)this.menuTopLevel.getItems().get(0)));
    }

    @Test
    public void makeMenuItemCommand() {
        WorkbenchMenuBarViewUnitTestWrapper spy = (WorkbenchMenuBarViewUnitTestWrapper)((Object)Mockito.spy((Object)((Object)this.workbenchMenuBarViewUnitTestWrapper)));
        MenuItemCommand item = MenusFixture.buildMenuItemCommand();
        Widget widget = spy.makeItem((MenuItem)item);
        ((WorkbenchMenuBarViewUnitTestWrapper)((Object)Mockito.verify((Object)((Object)spy), (VerificationMode)Mockito.times((int)1)))).makeMenuItemCommand((MenuItem)item);
    }

    @Test
    public void makeMenuGroup() {
        WorkbenchMenuBarViewUnitTestWrapper spy = (WorkbenchMenuBarViewUnitTestWrapper)((Object)Mockito.spy((Object)((Object)this.workbenchMenuBarViewUnitTestWrapper)));
        MenuItem item = MenusFixture.buildMenuGroupItem();
        Widget widget = spy.makeItem(item);
        ((WorkbenchMenuBarViewUnitTestWrapper)((Object)Mockito.verify((Object)((Object)spy), (VerificationMode)Mockito.times((int)1)))).makeMenuGroup((MenuGroup)item);
    }

    @Test
    public void makeMenuCustom() {
        WorkbenchMenuBarViewUnitTestWrapper spy = (WorkbenchMenuBarViewUnitTestWrapper)((Object)Mockito.spy((Object)((Object)this.workbenchMenuBarViewUnitTestWrapper)));
        MenuItem item = MenusFixture.buildCustomMenu();
        Widget widget = spy.makeItem(item);
        ((WorkbenchMenuBarViewUnitTestWrapper)((Object)Mockito.verify((Object)((Object)spy), (VerificationMode)Mockito.times((int)1)))).makeMenuCustom((MenuCustom)item);
    }

    @Test
    public void makeNavLink() {
        WorkbenchMenuBarViewUnitTestWrapper spy = (WorkbenchMenuBarViewUnitTestWrapper)((Object)Mockito.spy((Object)((Object)this.workbenchMenuBarViewUnitTestWrapper)));
        MenuItem item = (MenuItem)this.menuTopLevel.getItems().get(0);
        Widget widget = spy.makeItem(item);
        ((WorkbenchMenuBarViewUnitTestWrapper)((Object)Mockito.verify((Object)((Object)spy), (VerificationMode)Mockito.times((int)1)))).makeNavLink(item);
    }
}

