/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.menu;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.gwtbootstrap3.client.ui.html.Span;
import org.gwtbootstrap3.client.ui.html.Text;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.uberfire.client.views.pfly.menu.UtilityMenu;

@ApplicationScoped
public class UserMenu
extends UtilityMenu {
    @Inject
    private User user;
    @Inject
    private Caller<AuthenticationService> authService;
    private final DropDownMenu menu = new DropDownMenu();

    @PostConstruct
    private void setup() {
        this.anchor.addStyleName("dropdown-toggle");
        this.anchor.setDataToggle(Toggle.DROPDOWN);
        this.addStyleName("dropdown-toggle");
        Span userIcon = new Span();
        userIcon.addStyleName("pficon");
        userIcon.addStyleName("pficon-user");
        this.anchor.add((Widget)userIcon);
        this.anchor.add((Widget)new Text(this.formattedUsername()));
        Span caret = new Span();
        caret.addStyleName("caret");
        this.anchor.add((Widget)caret);
        this.addStyleName("dropdown");
        this.add((Widget)this.anchor);
        AnchorListItem logout = new AnchorListItem("Logout");
        logout.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                UserMenu.this.logout();
            }
        });
        this.menu.add((Widget)logout);
        this.add((Widget)this.menu);
    }

    public DropDownMenu getMenu() {
        return this.menu;
    }

    private String formattedUsername() {
        StringBuilder sb = new StringBuilder();
        if (this.user.getProperty("org.jboss.errai.security.FIRST_NAME") != null) {
            sb.append(this.user.getProperty("org.jboss.errai.security.FIRST_NAME"));
        }
        if (this.user.getProperty("org.jboss.errai.security.LAST_NAME") != null) {
            sb.append(" ");
            sb.append(this.user.getProperty("org.jboss.errai.security.LAST_NAME"));
        }
        if (sb.length() == 0) {
            sb.append(this.user.getIdentifier());
        }
        return sb.toString();
    }

    public void logout() {
        ((AuthenticationService)this.authService.call()).logout();
    }
}

