/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.menu;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Navbar;
import org.gwtbootstrap3.client.ui.NavbarBrand;
import org.gwtbootstrap3.client.ui.NavbarCollapse;
import org.gwtbootstrap3.client.ui.NavbarHeader;
import org.gwtbootstrap3.client.ui.NavbarNav;
import org.gwtbootstrap3.client.ui.base.AbstractListItem;
import org.jboss.errai.ioc.client.container.IOCResolutionException;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.client.views.pfly.menu.Bs3Menus;
import org.uberfire.client.views.pfly.menu.HasMenuItems;
import org.uberfire.client.views.pfly.menu.MainBrand;
import org.uberfire.client.views.pfly.menu.UtilityMenu;
import org.uberfire.client.views.pfly.menu.UtilityNavbar;
import org.uberfire.client.workbench.widgets.menu.WorkbenchMenuBarPresenter;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.menu.MenuPosition;
import org.uberfire.workbench.model.menu.Menus;

@ApplicationScoped
public class WorkbenchMenuBarView
extends Composite
implements WorkbenchMenuBarPresenter.View {
    @Inject
    private AuthorizationManager authzManager;
    @Inject
    private User identity;
    @Inject
    private Instance<MainBrand> menuBarBrand;
    private final NavbarNav primaryNavBar = new NavbarNav();
    @Inject
    private UtilityNavbar utilityNavbar;

    @PostConstruct
    private void setup() {
        Navbar root = new Navbar();
        root.addStyleName("navbar-pf");
        try {
            NavbarHeader headerContainer = new NavbarHeader();
            NavbarBrand brand = new NavbarBrand();
            brand.add((IsWidget)this.menuBarBrand.get());
            headerContainer.add((Widget)brand);
            root.add((Widget)headerContainer);
        }
        catch (IOCResolutionException e) {
            // empty catch block
        }
        NavbarCollapse collapsibleContainer = new NavbarCollapse();
        this.primaryNavBar.addStyleName("navbar-primary");
        collapsibleContainer.add((Widget)this.utilityNavbar);
        collapsibleContainer.add((Widget)this.primaryNavBar);
        root.add((Widget)collapsibleContainer);
        this.initWidget((Widget)root);
    }

    public void addMenuItems(Menus menus) {
        HasMenuItems topLevelContainer = new HasMenuItems(){

            public Widget asWidget() {
                return WorkbenchMenuBarView.this;
            }

            @Override
            public int getMenuItemCount() {
                return WorkbenchMenuBarView.this.primaryNavBar.getWidgetCount() + WorkbenchMenuBarView.this.utilityNavbar.getWidgetCount();
            }

            @Override
            public void addMenuItem(MenuPosition position, AbstractListItem menuContent) {
                if (menuContent instanceof UtilityMenu) {
                    WorkbenchMenuBarView.this.utilityNavbar.add((Widget)menuContent);
                } else {
                    if (position == null) {
                        position = MenuPosition.CENTER;
                    }
                    switch (position) {
                        case LEFT: {
                            WorkbenchMenuBarView.this.primaryNavBar.add((Widget)menuContent);
                            break;
                        }
                        case CENTER: {
                            WorkbenchMenuBarView.this.primaryNavBar.insert((Widget)menuContent, WorkbenchMenuBarView.this.primaryNavBar.getWidgetCount() - 1);
                        }
                        case RIGHT: {
                            menuContent.addStyleName("pull-right");
                            WorkbenchMenuBarView.this.primaryNavBar.add((Widget)menuContent);
                        }
                    }
                }
            }
        };
        Bs3Menus.constructMenuView(menus, this.authzManager, this.identity, topLevelContainer);
    }

    public void clear() {
        this.primaryNavBar.clear();
        this.utilityNavbar.clear();
    }
}

