/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.menu;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Stack;
import org.gwtbootstrap3.client.ui.AnchorButton;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.ListDropDown;
import org.gwtbootstrap3.client.ui.base.AbstractListItem;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.uberfire.client.views.pfly.menu.DropdownMenuVisitor;
import org.uberfire.client.views.pfly.menu.HasMenuItems;
import org.uberfire.workbench.model.menu.MenuCustom;
import org.uberfire.workbench.model.menu.MenuGroup;
import org.uberfire.workbench.model.menu.MenuItemCommand;
import org.uberfire.workbench.model.menu.MenuItemPerspective;
import org.uberfire.workbench.model.menu.MenuItemPlain;
import org.uberfire.workbench.model.menu.MenuPosition;
import org.uberfire.workbench.model.menu.Menus;

public class StackedDropdownMenuVisitor
extends DropdownMenuVisitor {
    final Stack<HasMenuItems> parentMenus = new Stack();

    public StackedDropdownMenuVisitor(HasMenuItems hasMenuItems) {
        super(hasMenuItems);
    }

    public boolean visitEnter(Menus menus) {
        this.parentMenus.push(this.hasMenuItems);
        return true;
    }

    public void visitLeave(Menus menus) {
        this.parentMenus.pop();
    }

    @Override
    public boolean visitEnter(MenuGroup menuGroup) {
        final ListDropDown listDropDown = new ListDropDown();
        AnchorButton anchor = new AnchorButton();
        anchor.setDataToggle(Toggle.DROPDOWN);
        anchor.setText(menuGroup.getCaption());
        final DropDownMenu dropDownMenu = new DropDownMenu();
        listDropDown.add((Widget)anchor);
        listDropDown.add((Widget)dropDownMenu);
        HasMenuItems hasMenuItems = new HasMenuItems(){

            @Override
            public void addMenuItem(MenuPosition position, Widget menuContent) {
                dropDownMenu.add(menuContent);
            }

            public Widget asWidget() {
                return listDropDown;
            }
        };
        this.parentMenus.push(hasMenuItems);
        return true;
    }

    public void visitLeave(MenuGroup menuGroup) {
        HasMenuItems groupMenu = this.parentMenus.pop();
        this.parentMenus.peek().addMenuItem(menuGroup.getPosition(), groupMenu.asWidget());
    }

    @Override
    public void visit(MenuCustom<?> menuCustom) {
        Widget customMenuItem = ((IsWidget)menuCustom.build()).asWidget();
        if (customMenuItem instanceof AbstractListItem) {
            AbstractListItem view = (AbstractListItem)customMenuItem;
            this.parentMenus.peek().addMenuItem(menuCustom.getPosition(), (Widget)view);
        } else {
            this.buildMenuCustom(menuCustom, this.parentMenus.peek());
        }
    }

    @Override
    public void visit(MenuItemCommand menuItemCommand) {
        this.buildMenuCommand(menuItemCommand, this.parentMenus.peek());
    }

    @Override
    public void visit(MenuItemPlain menuItemPlain) {
        this.buildMenuPlain(menuItemPlain, this.parentMenus.peek());
    }

    @Override
    public void visit(MenuItemPerspective menuItemPerspective) {
        this.buildMenuPerspective(menuItemPerspective, this.parentMenus.peek());
    }
}

