/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.menu;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.AnchorButton;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.ListDropDown;
import org.gwtbootstrap3.client.ui.NavbarNav;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.gwtbootstrap3.client.ui.html.Text;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.client.menu.AuthFilterMenuVisitor;
import org.uberfire.client.views.pfly.menu.DropdownMenuVisitor;
import org.uberfire.client.views.pfly.menu.HasMenuItems;
import org.uberfire.client.views.pfly.menu.WorkbenchMenuBarView;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuItemPerspective;
import org.uberfire.workbench.model.menu.MenuPosition;
import org.uberfire.workbench.model.menu.MenuVisitor;
import org.uberfire.workbench.model.menu.Menus;

@ApplicationScoped
public class WorkbenchMenuCompactNavBarView
extends NavbarNav
implements WorkbenchMenuBarView.NavBarView,
HasMenuItems {
    private final AnchorButton anchor = new AnchorButton();
    private final Text text = new Text();
    private final DropDownMenu dropDownMenu = new DropDownMenu();
    private final ListDropDown listDropDown = new ListDropDown();
    private final Map<MenuItemPerspective, Widget> listItemMap = new HashMap<MenuItemPerspective, Widget>();
    @Inject
    private AuthorizationManager authzManager;
    @Inject
    private User identity;

    @PostConstruct
    protected void setup() {
        this.addStyleName("uf-navbar-nav-compact");
        this.anchor.setDataToggle(Toggle.DROPDOWN);
        this.anchor.add((Widget)this.text);
        this.listDropDown.add((Widget)this.anchor);
        this.listDropDown.add((Widget)this.dropDownMenu);
        this.add((Widget)this.listDropDown);
    }

    @Override
    public void addMenuItem(MenuPosition position, Widget menuContent) {
        this.dropDownMenu.add(menuContent);
    }

    public void addMenus(Menus menus) {
        menus.accept((MenuVisitor)new AuthFilterMenuVisitor(this.authzManager, this.identity, (MenuVisitor)new CompactMenuVisitor(this)));
    }

    @Override
    public void selectMenu(MenuItem menu) {
        this.selectElement(menu.getCaption(), this.listItemMap.get(menu));
    }

    private void selectElement(String caption, Widget item) {
        Iterator iterator = this.dropDownMenu.iterator();
        while (iterator.hasNext()) {
            ((Widget)iterator.next()).removeStyleName("active");
        }
        if (item != null) {
            item.addStyleName("active");
        }
        this.text.setText(caption);
    }

    private class CompactMenuVisitor
    extends DropdownMenuVisitor {
        public CompactMenuVisitor(HasMenuItems hasMenuItems) {
            super(hasMenuItems);
        }

        @Override
        protected AnchorListItem createListItem(final MenuItem menuItem, HasMenuItems hasMenuItems) {
            final AnchorListItem item = super.createListItem(menuItem, hasMenuItems);
            item.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    WorkbenchMenuCompactNavBarView.this.selectElement(menuItem.getCaption(), (Widget)item);
                }
            });
            return item;
        }

        @Override
        protected Widget buildMenuPerspective(MenuItemPerspective menuItemPerspective, HasMenuItems hasMenuItems) {
            Widget item = super.buildMenuPerspective(menuItemPerspective, hasMenuItems);
            WorkbenchMenuCompactNavBarView.this.listItemMap.put(menuItemPerspective, item);
            return item;
        }
    }
}

