/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.tab;

import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import org.gwtbootstrap3.client.GwtBootstrap3EntryPoint;
import org.gwtbootstrap3.client.shared.event.TabShowHandler;
import org.gwtbootstrap3.client.shared.event.TabShownHandler;
import org.jboss.errai.enterprise.client.cdi.AbstractErraiCDITest;
import org.jboss.errai.ioc.client.container.IOC;
import org.uberfire.client.views.pfly.mock.CountingTabShowHandler;
import org.uberfire.client.views.pfly.mock.CountingTabShownHandler;
import org.uberfire.client.views.pfly.tab.TabPanelEntry;
import org.uberfire.client.views.pfly.tab.TabPanelWithDropdowns;

public class TabPanelWithDropdownsTest
extends AbstractErraiCDITest {
    private TabPanelWithDropdowns tabPanel;

    public String getModuleName() {
        return "org.uberfire.client.views.pfly.PatternFlyTabTests";
    }

    protected void gwtSetUp() throws Exception {
        super.gwtSetUp();
        this.tabPanel = (TabPanelWithDropdowns)IOC.getBeanManager().lookupBean(TabPanelWithDropdowns.class, new Annotation[0]).getInstance();
        new GwtBootstrap3EntryPoint().onModuleLoad();
    }

    public void testAddTabByTitleAndContent() throws Exception {
        Label content = new Label("First tab's content");
        TabPanelEntry item = this.tabPanel.addItem("First Tab", (Widget)content);
        TabPanelWithDropdownsTest.assertNotNull((Object)item.getTabWidget());
        TabPanelWithDropdownsTest.assertNotNull((Object)item.getContents());
        TabPanelWithDropdownsTest.assertEquals((String)item.getTitle(), (String)"First Tab");
        TabPanelWithDropdownsTest.assertNotNull((Object)content.getParent());
    }

    public void testShowTab() throws Exception {
        RootPanel.get().add((Widget)this.tabPanel);
        TabPanelEntry item1 = this.tabPanel.addItem("First Tab", (Widget)new Label("First tab's content"));
        TabPanelEntry item2 = this.tabPanel.addItem("Second Tab", (Widget)new Label("Second tab's content"));
        item2.showTab();
        item1.showTab();
        TabPanelWithDropdownsTest.assertTrue((boolean)item1.getContentPane().isActive());
        TabPanelWithDropdownsTest.assertTrue((boolean)item1.getTabWidget().isActive());
        TabPanelWithDropdownsTest.assertEquals((Object)item1, (Object)this.tabPanel.getActiveTab());
        TabPanelWithDropdownsTest.assertFalse((boolean)item2.getContentPane().isActive());
        TabPanelWithDropdownsTest.assertFalse((boolean)item2.getTabWidget().isActive());
    }

    public void testRemoveActiveTab() throws Exception {
        RootPanel.get().add((Widget)this.tabPanel);
        TabPanelEntry item1 = this.tabPanel.addItem("First Tab", (Widget)new Label("First tab's content"));
        TabPanelEntry item2 = this.tabPanel.addItem("Second Tab", (Widget)new Label("Second tab's content"));
        item2.showTab();
        item1.showTab();
        this.tabPanel.remove(item1);
        TabPanelWithDropdownsTest.assertTrue((boolean)item1.getTabWidget().isActive());
        TabPanelWithDropdownsTest.assertNull((Object)this.tabPanel.getActiveTab());
        TabPanelWithDropdownsTest.assertEquals((Object)item1.getContentPane(), (Object)item1.getContents().getParent());
        TabPanelWithDropdownsTest.assertNull((Object)item1.getContentPane().getParent());
        TabPanelWithDropdownsTest.assertFalse((boolean)item2.getContentPane().isActive());
        TabPanelWithDropdownsTest.assertFalse((boolean)item2.getTabWidget().isActive());
    }

    public void testRebroadcastShowEvents() throws Exception {
        RootPanel.get().add((Widget)this.tabPanel);
        CountingTabShowHandler showHandler = new CountingTabShowHandler();
        CountingTabShownHandler shownHandler = new CountingTabShownHandler();
        this.tabPanel.addShowHandler((TabShowHandler)showHandler);
        this.tabPanel.addShownHandler((TabShownHandler)shownHandler);
        TabPanelEntry item1 = this.tabPanel.addItem("First Tab", (Widget)new Label("First tab's content"));
        TabPanelWithDropdownsTest.assertNull((Object)this.tabPanel.getActiveTab());
        item1.showTab();
        TabPanelWithDropdownsTest.assertNotNull((Object)this.tabPanel.getActiveTab());
        TabPanelWithDropdownsTest.assertEquals((int)1, (int)showHandler.getEventCount());
        TabPanelWithDropdownsTest.assertEquals((int)1, (int)shownHandler.getEventCount());
    }
}

