/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.menu;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.apache.commons.lang3.RandomStringUtils;
import org.gwtbootstrap3.client.ui.base.AbstractListItem;
import org.gwtbootstrap3.client.ui.constants.Pull;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.menu.WorkbenchMenuStandardNavBarView;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuPosition;

@RunWith(value=GwtMockitoTestRunner.class)
public class WorkbenchMenuStandardNavBarViewTest {
    private WorkbenchMenuStandardNavBarView workbenchMenuStandardNavBarView;

    @Before
    public void setup() {
        this.workbenchMenuStandardNavBarView = (WorkbenchMenuStandardNavBarView)Mockito.spy(WorkbenchMenuStandardNavBarView.class);
        this.workbenchMenuStandardNavBarView.getMenuItemWidgetMap().put("menuItemId", Mockito.spy(ComplexPanel.class));
    }

    @Test
    public void testAddMenuItemWithoutParent() {
        String menuId = RandomStringUtils.random((int)10);
        String menuParentId = null;
        String label = RandomStringUtils.random((int)10);
        MenuPosition position = MenuPosition.RIGHT;
        Command command = new Command(){

            public void execute() {
            }
        };
        this.workbenchMenuStandardNavBarView.addMenuItem(menuId, label, menuParentId, command, position);
        ((WorkbenchMenuStandardNavBarView)Mockito.verify((Object)this.workbenchMenuStandardNavBarView)).positionMenuItem((AbstractListItem)Mockito.any(AbstractListItem.class), (MenuPosition)Mockito.eq((Object)position));
    }

    @Test
    public void testAddMenuItemWithParent() {
        String menuId = RandomStringUtils.random((int)10);
        String menuParentId = RandomStringUtils.random((int)10);
        String label = RandomStringUtils.random((int)10);
        MenuPosition position = MenuPosition.RIGHT;
        Command command = new Command(){

            public void execute() {
            }
        };
        this.workbenchMenuStandardNavBarView.addMenuItem(menuId, label, menuParentId, command, position);
        ((WorkbenchMenuStandardNavBarView)Mockito.verify((Object)this.workbenchMenuStandardNavBarView, (VerificationMode)Mockito.never())).positionMenuItem((AbstractListItem)Mockito.any(AbstractListItem.class), (MenuPosition)Mockito.eq((Object)position));
    }

    @Test
    public void testAddCustomMenuItem() {
        Widget menu = (Widget)GWT.create(Widget.class);
        MenuPosition position = MenuPosition.RIGHT;
        this.workbenchMenuStandardNavBarView.addCustomMenuItem(menu, position);
        ((WorkbenchMenuStandardNavBarView)Mockito.verify((Object)this.workbenchMenuStandardNavBarView)).positionMenuItem((Widget)Mockito.any(Widget.class), (MenuPosition)Mockito.eq((Object)position));
    }

    @Test
    public void testAddGroupMenuItem() {
        String menuId = RandomStringUtils.random((int)10);
        String label = RandomStringUtils.random((int)10);
        MenuPosition position = MenuPosition.RIGHT;
        this.workbenchMenuStandardNavBarView.addGroupMenuItem(menuId, label, position);
        ((WorkbenchMenuStandardNavBarView)Mockito.verify((Object)this.workbenchMenuStandardNavBarView)).positionMenuItem((AbstractListItem)Mockito.any(AbstractListItem.class), (MenuPosition)Mockito.eq((Object)position));
    }

    @Test
    public void testAddContextMenuItem() {
        String menuItemId = "menuItemId";
        String menuId = RandomStringUtils.random((int)10);
        String menuParentId = RandomStringUtils.random((int)10);
        String label = RandomStringUtils.random((int)10);
        MenuPosition position = MenuPosition.RIGHT;
        Command command = new Command(){

            public void execute() {
            }
        };
        this.workbenchMenuStandardNavBarView.addContextMenuItem("menuItemId", menuId, label, menuParentId, command, position);
        ((WorkbenchMenuStandardNavBarView)Mockito.verify((Object)this.workbenchMenuStandardNavBarView)).positionMenuItem((AbstractListItem)Mockito.any(AbstractListItem.class), (MenuPosition)Mockito.eq((Object)position));
    }

    @Test
    public void testAddContextGroupMenuItem() {
        String menuItemId = "menuItemId";
        String menuId = RandomStringUtils.random((int)10);
        String label = RandomStringUtils.random((int)10);
        MenuPosition position = MenuPosition.RIGHT;
        this.workbenchMenuStandardNavBarView.addContextGroupMenuItem("menuItemId", menuId, label, position);
        ((WorkbenchMenuStandardNavBarView)Mockito.verify((Object)this.workbenchMenuStandardNavBarView)).positionMenuItem((AbstractListItem)Mockito.any(AbstractListItem.class), (MenuPosition)Mockito.eq((Object)position));
    }

    @Test
    public void testPositionAbstractListItemOnLeft() {
        AbstractListItem menuItem = (AbstractListItem)Mockito.mock(AbstractListItem.class);
        MenuPosition position = MenuPosition.LEFT;
        this.workbenchMenuStandardNavBarView.positionMenuItem(menuItem, position);
        ((AbstractListItem)Mockito.verify((Object)menuItem, (VerificationMode)Mockito.never())).setPull(Pull.RIGHT);
    }

    @Test
    public void testPositionAbstractListItemOnRight() {
        AbstractListItem menuItem = (AbstractListItem)Mockito.mock(AbstractListItem.class);
        MenuPosition position = MenuPosition.RIGHT;
        this.workbenchMenuStandardNavBarView.positionMenuItem(menuItem, position);
        ((AbstractListItem)Mockito.verify((Object)menuItem)).setPull(Pull.RIGHT);
    }

    @Test
    public void testPositionWidgetOnLeft() {
        Widget menuItem = (Widget)Mockito.spy(Widget.class);
        MenuPosition position = MenuPosition.LEFT;
        this.workbenchMenuStandardNavBarView.positionMenuItem(menuItem, position);
        ((Style)Mockito.verify((Object)menuItem.getElement().getStyle(), (VerificationMode)Mockito.never())).setFloat(Style.Float.RIGHT);
    }

    @Test
    public void testPositionWidgetOnRight() {
        Widget menuItem = (Widget)Mockito.spy(Widget.class);
        MenuPosition position = MenuPosition.RIGHT;
        Mockito.when((Object)menuItem.getElement()).thenReturn(Mockito.spy(Element.class));
        Mockito.when((Object)menuItem.getElement().getStyle()).thenReturn(Mockito.spy(Style.class));
        this.workbenchMenuStandardNavBarView.positionMenuItem(menuItem, position);
        ((Style)Mockito.verify((Object)menuItem.getElement().getStyle())).setFloat(Style.Float.RIGHT);
    }
}

