/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.listbar;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.BeforeSelectionEvent;
import com.google.gwt.event.logical.shared.BeforeSelectionHandler;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.Panel;
import org.gwtbootstrap3.client.ui.PanelBody;
import org.gwtbootstrap3.client.ui.PanelHeader;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.Pull;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.jboss.errai.ioc.client.container.IOCResolutionException;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.client.menu.AuthFilterMenuVisitor;
import org.uberfire.client.util.Layouts;
import org.uberfire.client.views.pfly.listbar.PartListDropdown;
import org.uberfire.client.views.pfly.maximize.MaximizeToggleButton;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.panels.MaximizeToggleButtonPresenter;
import org.uberfire.client.workbench.panels.WorkbenchPanelPresenter;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchDragAndDropManager;
import org.uberfire.client.workbench.widgets.listbar.ListBarWidget;
import org.uberfire.client.workbench.widgets.listbar.ListbarPreferences;
import org.uberfire.client.workbench.widgets.listbar.ResizeFocusPanel;
import org.uberfire.commons.data.Pair;
import org.uberfire.mvp.Command;
import org.uberfire.plugin.PluginUtil;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.menu.MenuCustom;
import org.uberfire.workbench.model.menu.MenuGroup;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuItemCommand;
import org.uberfire.workbench.model.menu.MenuVisitor;
import org.uberfire.workbench.model.menu.impl.BaseMenuVisitor;

@Dependent
public class ListBarWidgetImpl
extends ResizeComposite
implements ListBarWidget {
    private static ListBarWidgetBinder uiBinder = (ListBarWidgetBinder)GWT.create(ListBarWidgetBinder.class);
    final Map<PartDefinition, FlowPanel> partContentView = new HashMap<PartDefinition, FlowPanel>();
    @Inject
    Instance<ListbarPreferences> optionalListBarPrefs;
    @Inject
    PanelManager panelManager;
    @UiField
    FocusPanel container;
    @UiField
    PartListDropdown titleDropDown;
    @UiField
    PanelHeader header;
    @UiField
    Panel panel;
    @UiField
    ButtonGroup contextMenu;
    @UiField
    Button closeButton;
    @UiField
    ButtonGroup toolBar;
    @UiField
    MaximizeToggleButton maximizeButton;
    MaximizeToggleButtonPresenter maximizeButtonPresenter;
    @UiField
    PanelBody content;
    WorkbenchPanelPresenter presenter;
    LinkedHashSet<PartDefinition> parts = new LinkedHashSet();
    Pair<PartDefinition, FlowPanel> currentPart;
    @Inject
    private AuthorizationManager authzManager;
    @Inject
    private User identity;

    @PostConstruct
    void postConstruct() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.maximizeButtonPresenter = new MaximizeToggleButtonPresenter((MaximizeToggleButtonPresenter.View)this.maximizeButton);
        this.titleDropDown.setHideOnSingleElement(this.getListbarPreferences().isHideTitleDropDownOnSingleElement());
        this.setupEventHandlers();
        Layouts.setToFillParent((Widget)this);
        this.scheduleResize();
    }

    void setupEventHandlers() {
        this.container.addMouseOutHandler(event -> this.titleDropDown.removeStyleName("open"));
        this.container.addFocusHandler(event -> {
            if (this.currentPart != null && this.currentPart.getK1() != null) {
                this.selectPart((PartDefinition)this.currentPart.getK1());
            }
        });
        this.maximizeButton.addClickHandler(event -> {
            if (this.maximizeButton.isMaximized()) {
                this.panelManager.onPartMaximized((PartDefinition)this.currentPart.getK1());
            } else {
                this.panelManager.onPartMinimized((PartDefinition)this.currentPart.getK1());
            }
        });
        this.closeButton.addClickHandler(event -> {
            if (this.currentPart != null) {
                if (this.maximizeButton.isMaximized()) {
                    this.panelManager.onPartMinimized((PartDefinition)this.currentPart.getK1());
                }
                this.panelManager.closePart((PartDefinition)this.currentPart.getK1());
            }
        });
        this.titleDropDown.addSelectionHandler((SelectionHandler<PartDefinition>)((SelectionHandler)event -> this.selectPart((PartDefinition)event.getSelectedItem())));
        this.titleDropDown.addCloseHandler((CloseHandler<PartDefinition>)((CloseHandler)event -> this.panelManager.closePart((PartDefinition)event.getTarget())));
    }

    ListbarPreferences getListbarPreferences() {
        try {
            return this.optionalListBarPrefs.isUnsatisfied() ? new ListbarPreferences() : (ListbarPreferences)this.optionalListBarPrefs.get();
        }
        catch (IOCResolutionException e) {
            return new ListbarPreferences();
        }
    }

    public void enableDnd() {
        this.titleDropDown.enableDragAndDrop();
    }

    public void disableDnd() {
        this.titleDropDown.disableDragAndDrop();
    }

    public void setPresenter(WorkbenchPanelPresenter presenter) {
        this.presenter = presenter;
    }

    public void setDndManager(WorkbenchDragAndDropManager dndManager) {
        this.titleDropDown.setDndManager(dndManager);
    }

    public void clear() {
        this.contextMenu.clear();
        this.header.setVisible(false);
        this.content.clear();
        this.parts.clear();
        this.partContentView.clear();
        this.titleDropDown.clear();
        this.currentPart = null;
    }

    public void addPart(WorkbenchPartPresenter.View view) {
        PartDefinition partDefinition = view.getPresenter().getDefinition();
        if (this.parts.contains(partDefinition)) {
            this.selectPart(partDefinition);
            return;
        }
        this.parts.add(partDefinition);
        FlowPanel panel = new FlowPanel();
        Layouts.setToFillParent((Widget)panel);
        panel.add((IsWidget)view);
        this.content.add((Widget)panel);
        this.partContentView.put(partDefinition, panel);
        if (partDefinition.isSelectable()) {
            this.titleDropDown.addPart(view);
        }
        this.header.setVisible(true);
        this.resizePanelBody();
        this.scheduleResize();
    }

    public void changeTitle(PartDefinition part, String title, IsWidget titleDecoration) {
        if (part.isSelectable()) {
            this.titleDropDown.changeTitle(part, title, titleDecoration);
        }
    }

    public boolean selectPart(PartDefinition part) {
        if (!this.parts.contains(part)) {
            return false;
        }
        if (this.currentPart != null) {
            if (((PartDefinition)this.currentPart.getK1()).equals(part)) {
                return true;
            }
            this.parts.add((PartDefinition)this.currentPart.getK1());
            this.panelManager.onPartHidden((PartDefinition)this.currentPart.getK1());
            ((FlowPanel)this.currentPart.getK2()).getElement().getStyle().setDisplay(Style.Display.NONE);
        }
        this.currentPart = Pair.newPair((Object)part, (Object)this.partContentView.get(part));
        ((FlowPanel)this.currentPart.getK2()).getElement().getStyle().setDisplay(Style.Display.BLOCK);
        this.parts.remove(this.currentPart.getK1());
        if (part.isSelectable()) {
            this.titleDropDown.selectPart(part);
            this.setupContextMenu();
            this.header.setVisible(true);
        } else {
            this.header.setVisible(false);
        }
        this.scheduleResize();
        this.resizePanelBody();
        SelectionEvent.fire((HasSelectionHandlers)this, (Object)part);
        return true;
    }

    void setupContextMenu() {
        this.contextMenu.clear();
        WorkbenchPartPresenter.View part = (WorkbenchPartPresenter.View)((FlowPanel)this.currentPart.getK2()).getWidget(0);
        if (part.getPresenter().getMenus() != null && part.getPresenter().getMenus().getItems().size() > 0) {
            for (MenuItem menuItem : part.getPresenter().getMenus().getItems()) {
                Widget result = this.makeItem(menuItem, true);
                if (result == null) continue;
                this.contextMenu.add(result);
            }
        }
        this.contextMenu.setVisible(this.contextMenu.getWidgetCount() > 0);
    }

    public boolean remove(PartDefinition part) {
        if (part.isSelectable()) {
            this.titleDropDown.removePart(part);
        }
        if (this.currentPart != null && ((PartDefinition)this.currentPart.getK1()).asString().equals(part.asString())) {
            PartDefinition nextPart = this.getNextPart(part);
            if (nextPart != null) {
                this.presenter.selectPart(nextPart);
            } else {
                this.clear();
            }
        }
        boolean removed = this.parts.remove(part);
        FlowPanel view = this.partContentView.remove(part);
        if (view != null) {
            this.content.remove((Widget)view);
        }
        if (this.currentPart == null) {
            this.header.setVisible(false);
        }
        this.resizePanelBody();
        this.scheduleResize();
        return removed;
    }

    PartDefinition getNextPart(PartDefinition currentSelectedPart) {
        PartDefinition nextPart = null;
        for (PartDefinition p : this.getUnselectedParts()) {
            if (currentSelectedPart.asString().equals(p.asString())) continue;
            if (nextPart == null || p.isSelectable()) {
                nextPart = p;
            }
            if (!p.isSelectable()) continue;
            break;
        }
        return nextPart;
    }

    public void setFocus(boolean hasFocus) {
    }

    public void addOnFocusHandler(Command command) {
    }

    public int getPartsSize() {
        if (this.currentPart == null) {
            return 0;
        }
        return this.parts.size() + 1;
    }

    public Collection<PartDefinition> getParts() {
        ArrayList<Object> allParts = new ArrayList<Object>();
        if (this.currentPart == null) {
            return this.parts;
        }
        allParts.add(this.currentPart.getK1());
        allParts.addAll(this.parts);
        return Collections.unmodifiableList(allParts);
    }

    public HandlerRegistration addBeforeSelectionHandler(BeforeSelectionHandler<PartDefinition> handler) {
        return this.addHandler((EventHandler)handler, BeforeSelectionEvent.getType());
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<PartDefinition> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }

    public void onResize() {
        if (!this.isAttached()) {
            return;
        }
        super.onResize();
        for (int i = 0; i < this.content.getWidgetCount(); ++i) {
            FlowPanel container = (FlowPanel)this.content.getWidget(i);
            Widget containedWidget = container.getWidget(0);
            if (!(containedWidget instanceof RequiresResize)) continue;
            ((RequiresResize)containedWidget).onResize();
        }
    }

    protected Widget makeItem(MenuItem item, final boolean isRoot) {
        final Widget[] menuWidget = new Widget[]{null};
        item.accept((MenuVisitor)new AuthFilterMenuVisitor(this.authzManager, this.identity, (MenuVisitor)new BaseMenuVisitor(){

            public boolean visitEnter(MenuGroup menuGroup) {
                menuWidget[0] = ListBarWidgetImpl.this.makeMenuGroup(menuGroup, isRoot);
                return false;
            }

            public void visit(MenuItemCommand menuItemCommand) {
                menuWidget[0] = ListBarWidgetImpl.this.makeMenuItemCommand(menuItemCommand, isRoot);
            }

            public void visit(MenuCustom<?> menuCustom) {
                menuWidget[0] = ListBarWidgetImpl.this.makeMenuCustom(menuCustom);
            }
        }));
        return menuWidget[0];
    }

    private Widget makeMenuItemCommand(MenuItemCommand cmdItem, boolean isRoot) {
        if (isRoot) {
            Button button = (Button)GWT.create(Button.class);
            button.setText(cmdItem.getCaption());
            button.setSize(ButtonSize.SMALL);
            button.setEnabled(cmdItem.isEnabled());
            button.addClickHandler(event -> cmdItem.getCommand().execute());
            cmdItem.addEnabledStateChangeListener(arg_0 -> ((Button)button).setEnabled(arg_0));
            return button;
        }
        AnchorListItem navbarLink = (AnchorListItem)GWT.create(AnchorListItem.class);
        navbarLink.setText(cmdItem.getCaption());
        if (!cmdItem.isEnabled()) {
            navbarLink.addStyleName("disabled");
        }
        navbarLink.addClickHandler(event -> cmdItem.getCommand().execute());
        cmdItem.addEnabledStateChangeListener(enabled -> {
            if (enabled) {
                navbarLink.removeStyleName("disabled");
            } else {
                navbarLink.addStyleName("disabled");
            }
        });
        return navbarLink;
    }

    private Widget makeMenuGroup(MenuGroup groups, boolean isRoot) {
        if (isRoot) {
            ArrayList<Widget> widgetList = new ArrayList<Widget>();
            for (MenuItem _item : PluginUtil.ensureIterable((List)groups.getItems())) {
                Widget widget = this.makeItem(_item, false);
                if (widget == null) continue;
                widgetList.add(widget);
            }
            if (widgetList.isEmpty()) {
                return null;
            }
            return this.makeDropDownMenuButton(groups.getCaption(), widgetList);
        }
        ArrayList<Widget> widgetList = new ArrayList<Widget>();
        for (MenuItem _item : groups.getItems()) {
            Widget result = this.makeItem(_item, false);
            if (result == null) continue;
            widgetList.add(result);
        }
        if (widgetList.isEmpty()) {
            return null;
        }
        return this.makeDropDownMenuButton(groups.getCaption(), widgetList);
    }

    private Widget makeMenuCustom(MenuCustom item) {
        Object result = item.build();
        if (result instanceof Widget) {
            return (Widget)result;
        }
        return null;
    }

    private Widget makeDropDownMenuButton(String caption, List<Widget> widgetList) {
        ButtonGroup buttonGroup = (ButtonGroup)GWT.create(ButtonGroup.class);
        Button dropdownButton = (Button)GWT.create(Button.class);
        dropdownButton.setText(caption);
        dropdownButton.setDataToggle(Toggle.DROPDOWN);
        dropdownButton.setSize(ButtonSize.SMALL);
        DropDownMenu dropDownMenu = (DropDownMenu)GWT.create(DropDownMenu.class);
        dropDownMenu.setPull(Pull.RIGHT);
        for (Widget _item : widgetList) {
            dropDownMenu.add(_item);
        }
        buttonGroup.add((Widget)dropdownButton);
        buttonGroup.add((Widget)dropDownMenu);
        return buttonGroup;
    }

    private void scheduleResize() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                ListBarWidgetImpl.this.onResize();
            }
        });
    }

    void resizePanelBody() {
        if (this.currentPart != null && !((PartDefinition)this.currentPart.getK1()).isSelectable()) {
            this.content.getElement().getStyle().setProperty("height", "100%");
        } else {
            this.content.getElement().getStyle().setProperty("height", "calc(100% - " + this.header.getOffsetHeight() + "px)");
        }
    }

    public MaximizeToggleButtonPresenter getMaximizeButton() {
        return this.maximizeButtonPresenter;
    }

    public boolean isDndEnabled() {
        return this.titleDropDown.isDndEnabled();
    }

    public void enableClosePart() {
        this.closeButton.setVisible(true);
    }

    public void disableClosePart() {
        this.closeButton.setVisible(false);
    }

    Collection<PartDefinition> getUnselectedParts() {
        return this.parts;
    }

    static interface ListBarWidgetBinder
    extends UiBinder<ResizeFocusPanel, ListBarWidgetImpl> {
    }
}

