/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.widgets;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.MouseEvent;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.client.views.pfly.widgets.Modal;
import org.uberfire.mvp.Command;

@Dependent
@Templated
public class ConfirmPopup {
    @Inject
    @DataField(value="confirm-title")
    Span modalTitle;
    @Inject
    @DataField(value="confirm-message")
    Span modalConfirmationMessageLabel;
    @Inject
    @DataField(value="confirm-ok-button-text")
    Span okButton;
    @Inject
    @DataField(value="modal")
    private Modal modal;
    private Command okCommand;

    public void show(String title, String okButtonText, String confirmMessage, Command okCommand) {
        this.okCommand = okCommand;
        this.modalTitle.setTextContent(title);
        this.okButton.setTextContent(okButtonText);
        this.modalConfirmationMessageLabel.setTextContent(confirmMessage);
        this.modal.show();
    }

    public void hide() {
        this.modal.hide();
    }

    public HTMLElement getElement() {
        return this.modal.getElement();
    }

    @EventHandler(value={"confirm-ok"})
    public void onOkClick(@ForEvent(value={"click"}) MouseEvent event) {
        if (this.okCommand != null) {
            this.okCommand.execute();
        }
        this.hide();
    }

    @EventHandler(value={"confirm-cancel"})
    public void onCancelClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.hide();
    }

    @EventHandler(value={"confirm-close"})
    public void onCloseClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.hide();
    }
}

