/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.multipage;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.gwtbootstrap3.client.ui.NavTabs;
import org.gwtbootstrap3.client.ui.TabPane;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.multipage.MultiPageEditorViewImpl;
import org.uberfire.client.views.pfly.tab.TabPanelEntry;
import org.uberfire.client.workbench.widgets.multipage.Page;
import org.uberfire.client.workbench.widgets.multipage.PageView;

@RunWith(value=GwtMockitoTestRunner.class)
public class MultiPageEditorViewImplTest {
    @Mock
    private TabPanelEntry.DropDownTabListItem dropDownTabListItem;
    @Mock
    private TabPane contentPane;
    @Mock
    private Page page;
    @Mock
    private TabPanelEntry tab;
    private MultiPageEditorViewImpl view;

    @Before
    public void setup() {
        this.view = (MultiPageEditorViewImpl)Mockito.spy((Object)new MultiPageEditorViewImpl());
        this.view.init();
    }

    @Test
    public void testAddPage() {
        ((MultiPageEditorViewImpl)Mockito.doReturn((Object)this.tab).when((Object)this.view)).makeTabPanelEntry(this.page);
        ((MultiPageEditorViewImpl)Mockito.doNothing().when((Object)this.view)).addItem((TabPanelEntry)Mockito.any());
        ((MultiPageEditorViewImpl)Mockito.doNothing().when((Object)this.view)).setAsActive((TabPanelEntry)Mockito.any());
        this.view.addPage(this.page);
        ((MultiPageEditorViewImpl)Mockito.verify((Object)this.view)).addItem(this.tab);
        ((MultiPageEditorViewImpl)Mockito.verify((Object)this.view)).setAsActive(this.tab);
    }

    @Test
    public void testAddPageWithIndex() {
        boolean index = true;
        ((MultiPageEditorViewImpl)Mockito.doReturn((Object)this.tab).when((Object)this.view)).makeTabPanelEntry(this.page);
        ((MultiPageEditorViewImpl)Mockito.doNothing().when((Object)this.view)).insertItem((TabPanelEntry)Mockito.any(), Mockito.anyInt());
        ((MultiPageEditorViewImpl)Mockito.doNothing().when((Object)this.view)).setAsActive((TabPanelEntry)Mockito.any());
        this.view.addPage(1, this.page);
        ((MultiPageEditorViewImpl)Mockito.verify((Object)this.view)).insertItem(this.tab, 1);
        ((MultiPageEditorViewImpl)Mockito.verify((Object)this.view)).setAsActive(this.tab);
    }

    @Test
    public void testMakeTabPanelEntry() {
        String title = "";
        PageView pageView = (PageView)Mockito.mock(PageView.class);
        Widget widget = (Widget)Mockito.mock(Widget.class);
        ((Page)Mockito.doReturn((Object)"").when((Object)this.page)).getLabel();
        ((Page)Mockito.doReturn((Object)pageView).when((Object)this.page)).getView();
        ((PageView)Mockito.doReturn((Object)widget).when((Object)pageView)).asWidget();
        TabPanelEntry tabPanelEntry = this.view.makeTabPanelEntry(this.page);
        Assert.assertEquals((Object)"", (Object)tabPanelEntry.getTitle());
        Assert.assertEquals((Object)widget, (Object)tabPanelEntry.getContents());
    }

    @Test
    public void testSetAsActiveWhenActiveTabIsNull() {
        ((MultiPageEditorViewImpl)Mockito.doReturn(null).when((Object)this.view)).getActiveTab();
        this.view.setAsActive(this.tab);
        ((TabPanelEntry)Mockito.verify((Object)this.tab)).showTab();
        ((TabPanelEntry)Mockito.verify((Object)this.tab)).setActive(true);
    }

    @Test
    public void testSetAsActiveWhenActiveTabIsNotNull() {
        ((MultiPageEditorViewImpl)Mockito.doReturn((Object)Mockito.mock(TabPanelEntry.class)).when((Object)this.view)).getActiveTab();
        this.view.setAsActive(this.tab);
        ((TabPanelEntry)Mockito.verify((Object)this.tab, (VerificationMode)Mockito.never())).showTab();
        ((TabPanelEntry)Mockito.verify((Object)this.tab, (VerificationMode)Mockito.never())).setActive(true);
    }

    @Test
    public void testDisablePage() {
        boolean index = true;
        Widget widget = (Widget)Mockito.mock(Widget.class);
        NavTabs navTabs = (NavTabs)Mockito.mock(NavTabs.class);
        Element element = (Element)Mockito.mock(Element.class);
        Style style = (Style)Mockito.mock(Style.class);
        ((MultiPageEditorViewImpl)Mockito.doReturn((Object)navTabs).when((Object)this.view)).getTabBar();
        ((NavTabs)Mockito.doReturn((Object)widget).when((Object)navTabs)).getWidget(1);
        ((Widget)Mockito.doReturn((Object)element).when((Object)widget)).getElement();
        ((Element)Mockito.doReturn((Object)style).when((Object)element)).getStyle();
        this.view.disablePage(1);
        ((Widget)Mockito.verify((Object)widget)).addStyleName("disabled");
        ((Style)Mockito.verify((Object)style)).setProperty("pointerEvents", "none");
    }

    @Test
    public void testEnablePage() {
        boolean index = true;
        Widget widget = (Widget)Mockito.mock(Widget.class);
        NavTabs navTabs = (NavTabs)Mockito.mock(NavTabs.class);
        Element element = (Element)Mockito.mock(Element.class);
        Style style = (Style)Mockito.mock(Style.class);
        ((MultiPageEditorViewImpl)Mockito.doReturn((Object)navTabs).when((Object)this.view)).getTabBar();
        ((NavTabs)Mockito.doReturn((Object)widget).when((Object)navTabs)).getWidget(1);
        ((Widget)Mockito.doReturn((Object)element).when((Object)widget)).getElement();
        ((Element)Mockito.doReturn((Object)style).when((Object)element)).getStyle();
        this.view.enablePage(1);
        ((Widget)Mockito.verify((Object)widget)).removeStyleName("disabled");
        ((Style)Mockito.verify((Object)style)).clearProperty("pointerEvents");
    }
}

