/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.tab;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.dom.client.HasMouseDownHandlers;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.TabListItem;
import org.gwtbootstrap3.client.ui.TabPane;
import org.gwtbootstrap3.client.ui.base.HasActive;

public class TabPanelEntry
implements HasActive {
    private final DropDownTabListItem tab;
    private final TabPane contentPane;
    private final Widget contents;
    private String title;

    public TabPanelEntry(String title, Widget contents) {
        this.title = title;
        this.tab = (DropDownTabListItem)((Object)GWT.create(DropDownTabListItem.class));
        this.tab.setText(title);
        this.contents = contents;
        this.contentPane = (TabPane)GWT.create(TabPane.class);
        this.contentPane.add(contents);
        this.tab.setDataTargetWidget((Widget)this.contentPane);
    }

    public DropDownTabListItem getTabWidget() {
        return this.tab;
    }

    public Widget getContents() {
        return this.contents;
    }

    public TabPane getContentPane() {
        return this.contentPane;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.tab.setText(title);
    }

    public void setInDropdown(boolean inDropdown) {
        this.tab.setInDropdown(inDropdown);
    }

    public boolean isActive() {
        return this.contentPane.isActive();
    }

    public void setActive(boolean b) {
        this.tab.setActive(b);
        this.contentPane.setActive(b);
    }

    public void showTab() {
        this.tab.showTab(false);
    }

    public String toString() {
        return "TabPanelEntry \"" + this.title + "\"";
    }

    public static class DropDownTabListItem
    extends TabListItem
    implements HasClickHandlers,
    HasMouseDownHandlers {
        public DropDownTabListItem() {
            this(null);
        }

        public DropDownTabListItem(String label) {
            super(label);
            this.addStyleName("uf-dropdown-tab-list-item");
        }

        public void setInDropdown(boolean inDropdown) {
            this.anchor.setTabIndex(inDropdown ? -1 : 0);
        }

        public void addToAnchor(Widget w) {
            this.anchor.add(w);
        }

        public HandlerRegistration addClickHandler(ClickHandler handler) {
            return this.addDomHandler((EventHandler)handler, ClickEvent.getType());
        }

        public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
            return this.addDomHandler((EventHandler)handler, MouseDownEvent.getType());
        }
    }
}

