/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.multiscreen;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.Node;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.multiscreen.MultiScreenPartWidget;
import org.uberfire.client.views.pfly.multiscreen.MultiScreenView;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;

@RunWith(value=GwtMockitoTestRunner.class)
public class MultiScreenPartWidgetTest {
    @Mock
    HTMLDivElement content;
    @Mock
    MultiScreenView multiScreenView;
    @Mock
    ManagedInstance<MultiScreenView> multiScreenViews;
    @Mock
    WorkbenchPartPresenter.View view;
    @Mock
    PartDefinition partDefinition;
    @InjectMocks
    MultiScreenPartWidget widget;

    @Before
    public void setup() {
        Mockito.when((Object)this.multiScreenViews.get()).thenReturn((Object)this.multiScreenView);
        WorkbenchPartPresenter presenter = (WorkbenchPartPresenter)Mockito.mock(WorkbenchPartPresenter.class);
        Mockito.when((Object)this.view.getPresenter()).thenReturn((Object)presenter);
        Mockito.when((Object)this.partDefinition.getParentPanel()).thenReturn(Mockito.mock(PanelDefinition.class));
        Mockito.when((Object)presenter.getDefinition()).thenReturn((Object)this.partDefinition);
    }

    @Test
    public void testInvalidRemovePart() {
        boolean removed = this.widget.remove(this.partDefinition);
        Assert.assertFalse((boolean)removed);
    }

    @Test
    public void testInvalidChangeTitle() {
        this.widget.changeTitle(this.partDefinition, null, null);
    }

    @Test
    public void testInvalidSelectPart() {
        boolean selected = this.widget.selectPart(this.partDefinition);
        Assert.assertFalse((boolean)selected);
    }

    @Test
    public void testChangeTitle() {
        String title = "newTitle";
        IsWidget titleWidget = (IsWidget)Mockito.mock(IsWidget.class);
        this.widget.addPart(this.view);
        this.widget.changeTitle(this.partDefinition, title, titleWidget);
        ((MultiScreenView)Mockito.verify((Object)this.multiScreenView)).setTitle(title);
        ((MultiScreenView)Mockito.verify((Object)this.multiScreenView)).setTitleWidget(titleWidget);
    }

    @Test
    public void testSelectPart() {
        this.widget.addPart(this.view);
        boolean selected = this.widget.selectPart(this.partDefinition);
        ((MultiScreenView)Mockito.verify((Object)this.multiScreenView, (VerificationMode)Mockito.times((int)2))).show();
        Assert.assertTrue((boolean)selected);
    }

    @Test
    public void testAddRemovePart() {
        this.widget.addPart(this.view);
        ((MultiScreenView)Mockito.verify((Object)this.multiScreenView)).setTitle((String)Mockito.any());
        ((MultiScreenView)Mockito.verify((Object)this.multiScreenView, (VerificationMode)Mockito.never())).setTitleWidget((IsWidget)Mockito.any());
        ((MultiScreenView)Mockito.verify((Object)this.multiScreenView)).setCloseHandler((Command)Mockito.any());
        ((MultiScreenView)Mockito.verify((Object)this.multiScreenView)).disableClose();
        ((MultiScreenView)Mockito.verify((Object)this.multiScreenView)).show();
        ((HTMLDivElement)Mockito.verify((Object)this.content)).appendChild((Node)Mockito.any());
        boolean removed = this.widget.remove(this.partDefinition);
        Assert.assertTrue((boolean)removed);
    }
}

