/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
export var HTML5_EVENTS = [
    {
        "name": "onabort",
        "description": "The loading of a resource has been aborted."
    },
    {
        "name": "onblur",
        "description": "An element has lost focus (does not bubble)."
    },
    {
        "name": "oncanplay",
        "description": "The user agent can play the media, but estimates that not enough data has been loaded to play the media up to its end without having to stop for further buffering of content."
    },
    {
        "name": "oncanplaythrough",
        "description": "The user agent can play the media up to its end without having to stop for further buffering of content."
    },
    {
        "name": "onchange",
        "description": "The change event is fired for <input>, <select>, and <textarea> elements when a change to the element's value is committed by the user."
    },
    {
        "name": "onclick",
        "description": "A pointing device button has been pressed and released on an element."
    },
    {
        "name": "oncontextmenu",
        "description": "The right button of the mouse is clicked (before the context menu is displayed)."
    },
    {
        "name": "ondblclick",
        "description": "A pointing device button is clicked twice on an element."
    },
    {
        "name": "ondrag",
        "description": "An element or text selection is being dragged (every 350ms)."
    },
    {
        "name": "ondragend",
        "description": "A drag operation is being ended (by releasing a mouse button or hitting the escape key)."
    },
    {
        "name": "ondragenter",
        "description": "A dragged element or text selection enters a valid drop target."
    },
    {
        "name": "ondragleave",
        "description": "A dragged element or text selection leaves a valid drop target."
    },
    {
        "name": "ondragover",
        "description": "An element or text selection is being dragged over a valid drop target (every 350ms)."
    },
    {
        "name": "ondragstart",
        "description": "The user starts dragging an element or text selection."
    },
    {
        "name": "ondrop",
        "description": "An element is dropped on a valid drop target."
    },
    {
        "name": "ondurationchange",
        "description": "The duration attribute has been updated."
    },
    {
        "name": "onemptied",
        "description": "The media has become empty; for example, this event is sent if the media has already been loaded (or partially loaded), and the load() method is called to reload it."
    },
    {
        "name": "onended",
        "description": "Playback has stopped because the end of the media was reached."
    },
    {
        "name": "onerror",
        "description": "A resource failed to load."
    },
    {
        "name": "onfocus",
        "description": "An element has received focus (does not bubble)."
    },
    {
        "name": "onformchange"
    },
    {
        "name": "onforminput"
    },
    {
        "name": "oninput",
        "description": "The value of an element changes or the content of an element with the attribute contenteditable is modified."
    },
    {
        "name": "oninvalid",
        "description": "A submittable element has been checked and doesn't satisfy its constraints."
    },
    {
        "name": "onkeydown",
        "description": "A key is pressed down."
    },
    {
        "name": "onkeypress",
        "description": "A key is pressed down and that key normally produces a character value (use input instead)."
    },
    {
        "name": "onkeyup",
        "description": "A key is released."
    },
    {
        "name": "onload",
        "description": "A resource and its dependent resources have finished loading."
    },
    {
        "name": "onloadeddata",
        "description": "The first frame of the media has finished loading."
    },
    {
        "name": "onloadedmetadata",
        "description": "The metadata has been loaded."
    },
    {
        "name": "onloadstart",
        "description": "Progress has begun."
    },
    {
        "name": "onmousedown",
        "description": "A pointing device button (usually a mouse) is pressed on an element."
    },
    {
        "name": "onmousemove",
        "description": "A pointing device is moved over an element."
    },
    {
        "name": "onmouseout",
        "description": "A pointing device is moved off the element that has the listener attached or off one of its children."
    },
    {
        "name": "onmouseover",
        "description": "A pointing device is moved onto the element that has the listener attached or onto one of its children."
    },
    {
        "name": "onmouseup",
        "description": "A pointing device button is released over an element."
    },
    {
        "name": "onmousewheel"
    },
    {
        "name": "onpause",
        "description": "Playback has been paused."
    },
    {
        "name": "onplay",
        "description": "Playback has begun."
    },
    {
        "name": "onplaying",
        "description": "Playback is ready to start after having been paused or delayed due to lack of data."
    },
    {
        "name": "onprogress",
        "description": "In progress."
    },
    {
        "name": "onratechange",
        "description": "The playback rate has changed."
    },
    {
        "name": "onreset",
        "description": "A form is reset."
    },
    {
        "name": "onresize",
        "description": "The document view has been resized."
    },
    {
        "name": "onreadystatechange",
        "description": "The readyState attribute of a document has changed."
    },
    {
        "name": "onscroll",
        "description": "The document view or an element has been scrolled."
    },
    {
        "name": "onseeked",
        "description": "A seek operation completed."
    },
    {
        "name": "onseeking",
        "description": "A seek operation began."
    },
    {
        "name": "onselect",
        "description": "Some text is being selected."
    },
    {
        "name": "onshow",
        "description": "A contextmenu event was fired on/bubbled to an element that has a contextmenu attribute"
    },
    {
        "name": "onstalled",
        "description": "The user agent is trying to fetch media data, but data is unexpectedly not forthcoming."
    },
    {
        "name": "onsubmit",
        "description": "A form is submitted."
    },
    {
        "name": "onsuspend",
        "description": "Media data loading has been suspended."
    },
    {
        "name": "ontimeupdate",
        "description": "The time indicated by the currentTime attribute has been updated."
    },
    {
        "name": "onvolumechange",
        "description": "The volume has changed."
    },
    {
        "name": "onwaiting",
        "description": "Playback has stopped because of a temporary lack of data."
    }
];
