/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.multipage;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.assertj.core.api.Assertions;
import org.gwtbootstrap3.client.shared.event.TabShownEvent;
import org.gwtbootstrap3.client.ui.NavTabs;
import org.gwtbootstrap3.client.ui.TabListItem;
import org.gwtbootstrap3.client.ui.TabPane;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.multipage.MultiPageEditorSelectedPageEvent;
import org.uberfire.client.views.pfly.multipage.MultiPageEditorViewImpl;
import org.uberfire.client.views.pfly.multipage.PageViewImpl;
import org.uberfire.client.views.pfly.tab.TabPanelEntry;
import org.uberfire.client.workbench.widgets.multipage.Page;
import org.uberfire.client.workbench.widgets.multipage.PageView;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class MultiPageEditorViewImplTest {
    @Mock
    private Page page;
    @Mock
    private TabPanelEntry tab;
    @Mock
    private EventSourceMock<MultiPageEditorSelectedPageEvent> selectedPageEvent;
    @Captor
    private ArgumentCaptor<MultiPageEditorSelectedPageEvent> pageEvent;
    private MultiPageEditorViewImpl view;

    @Before
    public void setup() {
        this.view = (MultiPageEditorViewImpl)Mockito.spy((Object)new MultiPageEditorViewImpl());
        this.view.init();
    }

    @Test
    public void testAddPage() {
        ((MultiPageEditorViewImpl)Mockito.doReturn((Object)this.tab).when((Object)this.view)).makeTabPanelEntry(this.page);
        ((MultiPageEditorViewImpl)Mockito.doNothing().when((Object)this.view)).addItem((TabPanelEntry)Mockito.any());
        ((MultiPageEditorViewImpl)Mockito.doNothing().when((Object)this.view)).setAsActive((TabPanelEntry)Mockito.any());
        this.view.addPage(this.page);
        ((MultiPageEditorViewImpl)Mockito.verify((Object)this.view)).addItem(this.tab);
        ((MultiPageEditorViewImpl)Mockito.verify((Object)this.view)).setAsActive(this.tab);
    }

    @Test
    public void testAddPageWithIndex() {
        boolean index = true;
        ((MultiPageEditorViewImpl)Mockito.doReturn((Object)this.tab).when((Object)this.view)).makeTabPanelEntry(this.page);
        ((MultiPageEditorViewImpl)Mockito.doNothing().when((Object)this.view)).insertItem((TabPanelEntry)Mockito.any(), Mockito.anyInt());
        ((MultiPageEditorViewImpl)Mockito.doNothing().when((Object)this.view)).setAsActive((TabPanelEntry)Mockito.any());
        this.view.addPage(1, this.page);
        ((MultiPageEditorViewImpl)Mockito.verify((Object)this.view)).insertItem(this.tab, 1);
        ((MultiPageEditorViewImpl)Mockito.verify((Object)this.view)).setAsActive(this.tab);
    }

    @Test
    public void testMakeTabPanelEntry() {
        String title = "";
        PageView pageView = (PageView)Mockito.mock(PageView.class);
        Widget widget = (Widget)Mockito.mock(Widget.class);
        ((Page)Mockito.doReturn((Object)"").when((Object)this.page)).getLabel();
        ((Page)Mockito.doReturn((Object)pageView).when((Object)this.page)).getView();
        ((PageView)Mockito.doReturn((Object)widget).when((Object)pageView)).asWidget();
        TabPanelEntry tabPanelEntry = this.view.makeTabPanelEntry(this.page);
        Assert.assertEquals((Object)"", (Object)tabPanelEntry.getTitle());
        Assert.assertEquals((Object)widget, (Object)tabPanelEntry.getContents());
    }

    @Test
    public void testSetAsActiveWhenActiveTabIsNull() {
        ((MultiPageEditorViewImpl)Mockito.doReturn(null).when((Object)this.view)).getActiveTab();
        this.view.setAsActive(this.tab);
        ((TabPanelEntry)Mockito.verify((Object)this.tab)).showTab();
        ((TabPanelEntry)Mockito.verify((Object)this.tab)).setActive(true);
    }

    @Test
    public void testSetAsActiveWhenActiveTabIsNotNull() {
        ((MultiPageEditorViewImpl)Mockito.doReturn((Object)Mockito.mock(TabPanelEntry.class)).when((Object)this.view)).getActiveTab();
        this.view.setAsActive(this.tab);
        ((TabPanelEntry)Mockito.verify((Object)this.tab, (VerificationMode)Mockito.never())).showTab();
        ((TabPanelEntry)Mockito.verify((Object)this.tab, (VerificationMode)Mockito.never())).setActive(true);
    }

    @Test
    public void testDisablePage() {
        boolean index = true;
        Widget widget = (Widget)Mockito.mock(Widget.class);
        NavTabs navTabs = (NavTabs)Mockito.mock(NavTabs.class);
        Element element = (Element)Mockito.mock(Element.class);
        Style style = (Style)Mockito.mock(Style.class);
        ((MultiPageEditorViewImpl)Mockito.doReturn((Object)navTabs).when((Object)this.view)).getTabBar();
        ((NavTabs)Mockito.doReturn((Object)widget).when((Object)navTabs)).getWidget(1);
        ((Widget)Mockito.doReturn((Object)element).when((Object)widget)).getElement();
        ((Element)Mockito.doReturn((Object)style).when((Object)element)).getStyle();
        ((MultiPageEditorViewImpl)Mockito.doReturn((Object)true).when((Object)this.view)).isValid(Mockito.anyInt());
        this.view.disablePage(1);
        ((Widget)Mockito.verify((Object)widget)).addStyleName("disabled");
        ((Style)Mockito.verify((Object)style)).setProperty("pointerEvents", "none");
    }

    @Test
    public void testEnablePage() {
        boolean index = true;
        Widget widget = (Widget)Mockito.mock(Widget.class);
        NavTabs navTabs = (NavTabs)Mockito.mock(NavTabs.class);
        Element element = (Element)Mockito.mock(Element.class);
        Style style = (Style)Mockito.mock(Style.class);
        ((MultiPageEditorViewImpl)Mockito.doReturn((Object)navTabs).when((Object)this.view)).getTabBar();
        ((NavTabs)Mockito.doReturn((Object)widget).when((Object)navTabs)).getWidget(1);
        ((Widget)Mockito.doReturn((Object)element).when((Object)widget)).getElement();
        ((Element)Mockito.doReturn((Object)style).when((Object)element)).getStyle();
        ((MultiPageEditorViewImpl)Mockito.doReturn((Object)true).when((Object)this.view)).isValid(Mockito.anyInt());
        this.view.enablePage(1);
        ((Widget)Mockito.verify((Object)widget)).removeStyleName("disabled");
        ((Style)Mockito.verify((Object)style)).clearProperty("pointerEvents");
    }

    @Test
    public void testGetTabShownHandler() {
        TabListItem tab = (TabListItem)Mockito.mock(TabListItem.class);
        TabShownEvent event = (TabShownEvent)Mockito.mock(TabShownEvent.class);
        TabPanelEntry tabPanelEntry = (TabPanelEntry)Mockito.mock(TabPanelEntry.class);
        TabPane tabPane = (TabPane)Mockito.mock(TabPane.class);
        PageViewImpl page = (PageViewImpl)Mockito.mock(PageViewImpl.class);
        int pageIndex = 42;
        Mockito.when((Object)event.getTab()).thenReturn((Object)tab);
        Mockito.when((Object)tabPanelEntry.getContentPane()).thenReturn((Object)tabPane);
        Mockito.when((Object)tabPane.getWidget(0)).thenReturn((Object)page);
        Mockito.when((Object)tab.getTabIndex()).thenReturn((Object)42);
        ((MultiPageEditorViewImpl)Mockito.doReturn((Object)tabPanelEntry).when((Object)this.view)).findEntryForTabWidget(tab);
        this.view.enableSelectedPageEvent(this.selectedPageEvent);
        this.view.getTabShownHandler().onShown(event);
        ((MultiPageEditorViewImpl)Mockito.verify((Object)this.view)).onResize();
        ((EventSourceMock)Mockito.verify(this.selectedPageEvent)).fire(this.pageEvent.capture());
        ((PageViewImpl)Mockito.verify((Object)page)).onLostFocus();
        Assert.assertEquals((long)42L, (long)((MultiPageEditorSelectedPageEvent)this.pageEvent.getValue()).getSelectedPage());
    }

    @Test
    public void testGetPageIndex() {
        NavTabs navTabs = (NavTabs)Mockito.mock(NavTabs.class);
        ((MultiPageEditorViewImpl)Mockito.doReturn((Object)navTabs).when((Object)this.view)).getTabBar();
        TabListItem pageOne = (TabListItem)Mockito.mock(TabListItem.class);
        TabListItem pageTwo = (TabListItem)Mockito.mock(TabListItem.class);
        TabListItem pageThree = (TabListItem)Mockito.mock(TabListItem.class);
        ((NavTabs)Mockito.doReturn((Object)3).when((Object)navTabs)).getWidgetCount();
        ((NavTabs)Mockito.doReturn((Object)pageOne).when((Object)navTabs)).getWidget(0);
        ((NavTabs)Mockito.doReturn((Object)pageTwo).when((Object)navTabs)).getWidget(1);
        ((NavTabs)Mockito.doReturn((Object)pageThree).when((Object)navTabs)).getWidget(2);
        ((TabListItem)Mockito.doReturn((Object)"page 1").when((Object)pageOne)).getText();
        ((TabListItem)Mockito.doReturn((Object)"page 2").when((Object)pageTwo)).getText();
        ((TabListItem)Mockito.doReturn((Object)"page 3").when((Object)pageThree)).getText();
        Assertions.assertThat((int)this.view.getPageIndex("page 3")).isEqualTo(2);
        Assertions.assertThat((int)this.view.getPageIndex("page 2")).isEqualTo(1);
        Assertions.assertThat((int)this.view.getPageIndex("page 1")).isEqualTo(0);
        Assertions.assertThatThrownBy(() -> this.view.getPageIndex("xyz")).hasMessage("Page with title: 'xyz' doesn't exist.");
    }
}

