/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.widgets;

import elemental2.dom.Document;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import elemental2.dom.Text;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.elemental2.IsElement;
import org.uberfire.mvp.Command;

@Dependent
public class Button
implements IsElement {
    @Inject
    private HTMLButtonElement button;
    @Inject
    private Document document;
    private Text textNode;

    public void setText(String text) {
        if (this.textNode == null) {
            this.textNode = this.document.createTextNode(text);
            this.getElement().appendChild((Node)this.textNode);
        } else {
            this.textNode.textContent = text;
        }
    }

    public void setClickHandler(Command clickHandler) {
        this.button.addEventListener("click", e -> clickHandler.execute());
    }

    public void setType(ButtonType type) {
        this.button.type = type.name().toLowerCase();
    }

    public void setButtonStyleType(ButtonStyleType type) {
        this.removeClass("btn");
        Stream.of(ButtonStyleType.values()).forEach(buttonStyleType -> this.removeClass(buttonStyleType.getCssClass()));
        this.addClass((HTMLElement)this.button, "btn", type.getCssClass());
    }

    public void setEnabled(boolean enabled) {
        boolean bl = this.button.disabled = !enabled;
        if (enabled) {
            this.button.classList.remove(new String[]{"disabled"});
        } else {
            this.button.classList.add(new String[]{"disabled"});
        }
    }

    public void hide() {
        this.button.classList.add(new String[]{"hidden"});
    }

    public void show() {
        this.button.classList.remove(new String[]{"hidden"});
    }

    public void addIcon(String ... classes) {
        HTMLElement span = (HTMLElement)this.document.createElement("span");
        this.addClass(span, classes);
        this.button.appendChild((Node)span);
    }

    public HTMLElement getElement() {
        return this.button;
    }

    private void addClass(HTMLElement element, String ... classes) {
        for (String cssClass : classes) {
            if (element.classList.contains(cssClass)) continue;
            element.classList.add(new String[]{cssClass});
        }
    }

    private void removeClass(String cssClass) {
        if (this.getElement().classList.contains(cssClass)) {
            this.getElement().classList.remove(new String[]{cssClass});
        }
    }

    public static enum ButtonStyleType {
        DEFAULT("btn-default"),
        PRIMARY("btn-primary"),
        SUCCESS("btn-success"),
        INFO("btn-info"),
        WARNING("btn-warning"),
        DANGER("btn-danger"),
        LINK("btn-link");

        private final String cssClass;

        private ButtonStyleType(String cssClass) {
            this.cssClass = cssClass;
        }

        public String getCssClass() {
            return this.cssClass;
        }
    }

    public static enum ButtonType {
        BUTTON,
        SUBMIT,
        RESET;

    }
}

