/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.monaco;

import com.google.gwt.core.client.JsArrayString;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.uberfire.client.views.pfly.monaco.MonacoEditorInitializer;
import org.uberfire.client.views.pfly.monaco.jsinterop.Monaco;
import org.uberfire.client.views.pfly.monaco.jsinterop.MonacoLoader;

@RunWith(value=GwtMockitoTestRunner.class)
public class MonacoEditorInitializerTest {
    private MonacoEditorInitializer tested;

    @Before
    public void setup() {
        this.tested = (MonacoEditorInitializer)Mockito.spy((Object)new MonacoEditorInitializer());
    }

    @Test
    public void testRequireOnlyEditorModule() {
        Assert.assertFalse((boolean)this.testRequire(new String[0]));
    }

    @Test
    public void testRequireModules() {
        Assert.assertTrue((boolean)this.testRequire(new String[]{"someModulePathHere"}));
    }

    private boolean testRequire(final String[] modules) {
        final JsArrayString mainModuleJsArray = (JsArrayString)Mockito.mock(JsArrayString.class);
        final JsArrayString modulesArray = (JsArrayString)Mockito.mock(JsArrayString.class);
        ((MonacoEditorInitializer)Mockito.doAnswer((Answer)new Answer<JsArrayString>(){

            public JsArrayString answer(InvocationOnMock invocation) throws Throwable {
                String arg = (String)invocation.getArguments()[0];
                if ("vs/editor/editor.main".equals(arg)) {
                    return mainModuleJsArray;
                }
                if (modules.length > 0 && modules[0].equals(arg)) {
                    return modulesArray;
                }
                return null;
            }
        }).when((Object)this.tested)).toJsArrayString((String[])Matchers.any());
        boolean[] callbackExecuted = new boolean[]{false};
        boolean[] mainModulesLoadingExecuted = new boolean[]{false};
        boolean[] modulesLoadingExecuted = new boolean[]{false};
        Consumer<Monaco> monacoConsumer = monaco -> {
            callbackExecuted[0] = true;
        };
        Monaco monaco2 = (Monaco)Mockito.mock(Monaco.class);
        BiConsumer<JsArrayString, MonacoLoader.CallbackFunction> monacoLoader = (array, callback) -> {
            if (array == mainModuleJsArray) {
                mainModulesLoadingExecuted[0] = true;
                callback.call(monaco2);
            }
            if (array == modulesArray) {
                modulesLoadingExecuted[0] = true;
                callback.call(monaco2);
            }
        };
        this.tested.require(monacoLoader, monacoConsumer, modules);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.tested});
        ((MonacoEditorInitializer)inOrder.verify((Object)this.tested, Mockito.times((int)1))).switchAMDLoaderFromDefaultToMonaco();
        ((MonacoEditorInitializer)inOrder.verify((Object)this.tested, Mockito.times((int)1))).switchAMDLoaderFromMonacoToDefault();
        Assert.assertTrue((boolean)mainModulesLoadingExecuted[0]);
        Assert.assertTrue((boolean)callbackExecuted[0]);
        return modulesLoadingExecuted[0];
    }
}

