/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.widgets;

import elemental2.dom.DOMTokenList;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLDocument;
import elemental2.dom.HTMLLIElement;
import elemental2.dom.HTMLUListElement;
import elemental2.dom.Node;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.client.views.pfly.widgets.KebabMenu;

@RunWith(value=MockitoJUnitRunner.class)
public class KebabMenuTest {
    @Mock
    HTMLUListElement dropdownMenu;
    @Mock
    HTMLDocument document;
    @Mock
    HTMLDivElement kebab;
    @InjectMocks
    KebabMenu kebabMenu;

    @Before
    public void setup() {
        HTMLLIElement element = (HTMLLIElement)Mockito.mock(HTMLLIElement.class);
        element.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)this.document.createElement("li")).thenReturn((Object)element);
        this.kebab.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
    }

    @Test
    public void testAddSeparator() {
        this.kebabMenu.addSeparator();
        ((HTMLUListElement)Mockito.verify((Object)this.dropdownMenu)).appendChild((Node)Matchers.any(HTMLLIElement.class));
    }

    @Test
    public void testDropPositionUp() {
        this.kebabMenu.setDropPosition(KebabMenu.DropPosition.UP);
        ((DOMTokenList)Mockito.verify((Object)this.kebab.classList)).add(new String[]{"dropup"});
        ((DOMTokenList)Mockito.verify((Object)this.kebab.classList)).remove(new String[]{"dropdown"});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.kebab.classList});
    }

    @Test
    public void testDropPositionDown() {
        this.kebabMenu.setDropPosition(KebabMenu.DropPosition.DOWN);
        ((DOMTokenList)Mockito.verify((Object)this.kebab.classList)).remove(new String[]{"dropup"});
        ((DOMTokenList)Mockito.verify((Object)this.kebab.classList)).add(new String[]{"dropdown"});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.kebab.classList});
    }
}

