/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.menu;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.DropDownHeader;
import org.jboss.errai.ioc.client.container.IOC;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.views.pfly.menu.HasMenuItems;
import org.uberfire.workbench.model.menu.EnabledStateChangeListener;
import org.uberfire.workbench.model.menu.MenuCustom;
import org.uberfire.workbench.model.menu.MenuGroup;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuItemCommand;
import org.uberfire.workbench.model.menu.MenuItemPerspective;
import org.uberfire.workbench.model.menu.MenuItemPlain;
import org.uberfire.workbench.model.menu.impl.BaseMenuVisitor;

public class DropdownMenuVisitor
extends BaseMenuVisitor {
    protected final HasMenuItems hasMenuItems;

    public DropdownMenuVisitor(HasMenuItems hasMenuItems) {
        this.hasMenuItems = hasMenuItems;
    }

    public boolean visitEnter(MenuGroup menuGroup) {
        this.buildMenuGroup(menuGroup, this.hasMenuItems);
        return true;
    }

    protected Widget buildMenuGroup(MenuGroup menuGroup, HasMenuItems hasMenuItems) {
        DropDownHeader group = new DropDownHeader();
        group.setText(menuGroup.getCaption());
        hasMenuItems.addMenuItem(menuGroup.getPosition(), (Widget)group);
        return group;
    }

    public void visit(MenuCustom<?> menuCustom) {
        Widget customMenuItem = ((IsWidget)menuCustom.build()).asWidget();
        if (customMenuItem instanceof AnchorListItem) {
            AnchorListItem view = (AnchorListItem)customMenuItem;
            this.setupEnableDisable((MenuItem)menuCustom, view);
            this.hasMenuItems.addMenuItem(menuCustom.getPosition(), (Widget)view);
        } else {
            this.buildMenuCustom(menuCustom, this.hasMenuItems);
        }
    }

    protected Widget buildMenuCustom(MenuCustom<?> menuCustom, HasMenuItems hasMenuItems) {
        return this.createListItem((MenuItem)menuCustom, hasMenuItems);
    }

    public void visit(MenuItemCommand menuItemCommand) {
        this.buildMenuCommand(menuItemCommand, this.hasMenuItems);
    }

    protected Widget buildMenuCommand(final MenuItemCommand menuItemCommand, HasMenuItems hasMenuItems) {
        AnchorListItem item = this.createListItem((MenuItem)menuItemCommand, hasMenuItems);
        item.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                menuItemCommand.getCommand().execute();
            }
        });
        return item;
    }

    public void visit(MenuItemPerspective menuItemPerspective) {
        this.buildMenuPerspective(menuItemPerspective, this.hasMenuItems);
    }

    protected Widget buildMenuPerspective(final MenuItemPerspective menuItemPerspective, HasMenuItems hasMenuItems) {
        AnchorListItem item = this.createListItem((MenuItem)menuItemPerspective, hasMenuItems);
        item.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ((PlaceManager)IOC.getBeanManager().lookupBean(PlaceManager.class, new Annotation[0]).getInstance()).goTo(menuItemPerspective.getPlaceRequest());
            }
        });
        return item;
    }

    public void visit(MenuItemPlain menuItemPlain) {
        this.buildMenuPlain(menuItemPlain, this.hasMenuItems);
    }

    protected Widget buildMenuPlain(MenuItemPlain menuItemPlain, HasMenuItems hasMenuItems) {
        return this.createListItem((MenuItem)menuItemPlain, hasMenuItems);
    }

    protected AnchorListItem createListItem(MenuItem menuItem, HasMenuItems hasMenuItems) {
        AnchorListItem option = (AnchorListItem)GWT.create(AnchorListItem.class);
        option.setText(menuItem.getCaption());
        this.setupEnableDisable(menuItem, option);
        hasMenuItems.addMenuItem(menuItem.getPosition(), (Widget)option);
        return option;
    }

    protected void setupEnableDisable(MenuItem model, final AnchorListItem view) {
        view.setEnabled(model.isEnabled());
        model.addEnabledStateChangeListener(new EnabledStateChangeListener(){

            public void enabledStateChanged(boolean enabled) {
                view.setEnabled(enabled);
            }
        });
    }
}

