/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.menu;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import org.apache.commons.lang3.RandomStringUtils;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.ListDropDown;
import org.gwtbootstrap3.client.ui.ListItem;
import org.gwtbootstrap3.client.ui.NavbarNav;
import org.gwtbootstrap3.client.ui.base.AbstractListItem;
import org.gwtbootstrap3.client.ui.constants.Pull;
import org.gwtbootstrap3.client.ui.html.UnorderedList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.menu.WorkbenchMenuStandardNavBarView;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuPosition;

@RunWith(value=GwtMockitoTestRunner.class)
public class WorkbenchMenuStandardNavBarViewTest {
    @GwtMock
    NavbarNav navbarNav;
    @GwtMock
    ListItem listItem;
    @GwtMock
    AnchorListItem anchorListItem;
    @GwtMock
    ListDropDown listDropDown;
    @GwtMock
    Anchor anchor;
    @GwtMock
    DropDownMenu dropDownMenu;
    @GwtMock
    UnorderedList unorderedList;
    private WorkbenchMenuStandardNavBarView workbenchMenuStandardNavBarView;

    @Before
    public void setup() {
        this.workbenchMenuStandardNavBarView = (WorkbenchMenuStandardNavBarView)Mockito.spy(WorkbenchMenuStandardNavBarView.class);
        this.workbenchMenuStandardNavBarView.getMenuItemWidgetMap().put("menuItemId", Mockito.spy(ComplexPanel.class));
    }

    @Test
    public void testAddMenuItemWithoutParent() {
        String menuId = RandomStringUtils.random((int)10);
        String menuParentId = null;
        String label = RandomStringUtils.random((int)10);
        MenuPosition position = MenuPosition.RIGHT;
        Command command = (Command)Mockito.mock(Command.class);
        this.workbenchMenuStandardNavBarView.addMenuItem(menuId, label, menuParentId, command, position);
        ((WorkbenchMenuStandardNavBarView)Mockito.verify((Object)this.workbenchMenuStandardNavBarView)).positionMenuItem((AbstractListItem)Mockito.any(AbstractListItem.class), (MenuPosition)Mockito.eq((Object)position));
    }

    @Test
    public void testAddMenuItemWithParent() {
        String menuId = RandomStringUtils.random((int)10);
        String menuParentId = RandomStringUtils.random((int)10);
        String label = RandomStringUtils.random((int)10);
        MenuPosition position = MenuPosition.RIGHT;
        Command command = (Command)Mockito.mock(Command.class);
        this.workbenchMenuStandardNavBarView.addMenuItem(menuId, label, menuParentId, command, position);
        ((WorkbenchMenuStandardNavBarView)Mockito.verify((Object)this.workbenchMenuStandardNavBarView, (VerificationMode)Mockito.never())).positionMenuItem((AbstractListItem)Mockito.any(AbstractListItem.class), (MenuPosition)Mockito.eq((Object)position));
    }

    @Test
    public void testAddCustomMenuItem() {
        Widget menu = (Widget)GWT.create(Widget.class);
        MenuPosition position = MenuPosition.RIGHT;
        this.workbenchMenuStandardNavBarView.addCustomMenuItem(menu, position);
        ((WorkbenchMenuStandardNavBarView)Mockito.verify((Object)this.workbenchMenuStandardNavBarView)).positionMenuItem((Widget)Mockito.any(Widget.class), (MenuPosition)Mockito.eq((Object)position));
    }

    @Test
    public void testAddGroupMenuItem() {
        String menuId = RandomStringUtils.random((int)10);
        String label = RandomStringUtils.random((int)10);
        MenuPosition position = MenuPosition.RIGHT;
        this.workbenchMenuStandardNavBarView.addGroupMenuItem(menuId, label, position);
        ((WorkbenchMenuStandardNavBarView)Mockito.verify((Object)this.workbenchMenuStandardNavBarView)).positionMenuItem((AbstractListItem)Mockito.any(AbstractListItem.class), (MenuPosition)Mockito.eq((Object)position));
    }

    @Test
    public void testAddContextMenuItem() {
        String menuItemId = "menuItemId";
        String menuId = RandomStringUtils.random((int)10);
        String menuParentId = RandomStringUtils.random((int)10);
        String label = RandomStringUtils.random((int)10);
        MenuPosition position = MenuPosition.RIGHT;
        Command command = (Command)Mockito.mock(Command.class);
        this.workbenchMenuStandardNavBarView.addContextMenuItem("menuItemId", menuId, label, menuParentId, command, position);
        ((WorkbenchMenuStandardNavBarView)Mockito.verify((Object)this.workbenchMenuStandardNavBarView)).positionMenuItem((AbstractListItem)Mockito.any(AbstractListItem.class), (MenuPosition)Mockito.eq((Object)position));
        ((AnchorListItem)Mockito.verify((Object)this.anchorListItem)).setText(label);
        Assert.assertEquals((Object)this.anchorListItem, this.workbenchMenuStandardNavBarView.getMenuItemContextWidgetMap().get(menuId));
    }

    @Test
    public void testAddContextGroupMenuItem() {
        String menuItemId = "menuItemId";
        String menuId = RandomStringUtils.random((int)10);
        String label = RandomStringUtils.random((int)10);
        MenuPosition position = MenuPosition.RIGHT;
        this.workbenchMenuStandardNavBarView.addContextGroupMenuItem("menuItemId", menuId, label, position);
        ((WorkbenchMenuStandardNavBarView)Mockito.verify((Object)this.workbenchMenuStandardNavBarView)).positionMenuItem((AbstractListItem)Mockito.any(AbstractListItem.class), (MenuPosition)Mockito.eq((Object)position));
        ((Anchor)Mockito.verify((Object)this.anchor)).setText(label);
        ((ListDropDown)Mockito.verify((Object)this.listDropDown)).add((Widget)this.anchor);
        Assert.assertEquals((Object)this.dropDownMenu, this.workbenchMenuStandardNavBarView.getMenuItemContextWidgetMap().get(menuId));
    }

    @Test
    public void testPositionAbstractListItemOnLeft() {
        AbstractListItem menuItem = (AbstractListItem)Mockito.mock(AbstractListItem.class);
        MenuPosition position = MenuPosition.LEFT;
        this.workbenchMenuStandardNavBarView.positionMenuItem(menuItem, position);
        ((AbstractListItem)Mockito.verify((Object)menuItem, (VerificationMode)Mockito.never())).setPull(Pull.RIGHT);
    }

    @Test
    public void testPositionAbstractListItemOnRight() {
        AbstractListItem menuItem = (AbstractListItem)Mockito.mock(AbstractListItem.class);
        MenuPosition position = MenuPosition.RIGHT;
        this.workbenchMenuStandardNavBarView.positionMenuItem(menuItem, position);
        ((AbstractListItem)Mockito.verify((Object)menuItem)).setPull(Pull.RIGHT);
    }

    @Test
    public void testPositionWidgetOnLeft() {
        Widget menuItem = (Widget)Mockito.spy(Widget.class);
        MenuPosition position = MenuPosition.LEFT;
        this.workbenchMenuStandardNavBarView.positionMenuItem(menuItem, position);
        ((Style)Mockito.verify((Object)menuItem.getElement().getStyle(), (VerificationMode)Mockito.never())).setFloat(Style.Float.RIGHT);
    }

    @Test
    public void testPositionWidgetOnRight() {
        Widget menuItem = (Widget)Mockito.spy(Widget.class);
        MenuPosition position = MenuPosition.RIGHT;
        Mockito.when((Object)menuItem.getElement()).thenReturn(Mockito.spy(Element.class));
        Mockito.when((Object)menuItem.getElement().getStyle()).thenReturn(Mockito.spy(Style.class));
        this.workbenchMenuStandardNavBarView.positionMenuItem(menuItem, position);
        ((Style)Mockito.verify((Object)menuItem.getElement().getStyle())).setFloat(Style.Float.RIGHT);
    }

    @Test
    public void testSelectElement() {
        ListDropDown parent1 = (ListDropDown)Mockito.mock(ListDropDown.class);
        Widget parent2 = (Widget)Mockito.mock(Widget.class);
        ComplexPanel panel = (ComplexPanel)Mockito.mock(ComplexPanel.class);
        Mockito.when((Object)this.navbarNav.iterator()).thenReturn(Collections.emptyList().iterator());
        Mockito.when((Object)panel.getParent()).thenReturn((Object)parent2);
        Mockito.when((Object)parent2.getParent()).thenReturn((Object)parent1);
        this.workbenchMenuStandardNavBarView.selectElement(panel);
        ((ComplexPanel)Mockito.verify((Object)panel)).addStyleName("active");
        ((ListDropDown)Mockito.verify((Object)parent1)).addStyleName("active");
    }

    @Test
    public void testSelectMenuItemNoMenu() {
        String menuId = "menuId";
        Mockito.when((Object)this.navbarNav.iterator()).thenReturn(Collections.emptyList().iterator());
        Mockito.when((Object)this.listItem.getParent()).thenReturn(Mockito.mock(Widget.class));
        this.workbenchMenuStandardNavBarView.selectMenuItem("menuId");
        ((NavbarNav)Mockito.verify((Object)this.navbarNav)).add((Widget)this.listItem);
    }

    @Test
    public void testSelectMenuItem() {
        String menuId = "menuId";
        String label = "label";
        Mockito.when((Object)this.navbarNav.iterator()).thenReturn(Collections.emptyList().iterator());
        Mockito.when((Object)this.anchorListItem.getParent()).thenReturn(Mockito.mock(Widget.class));
        Widget ulParent = (Widget)Mockito.mock(Widget.class);
        Mockito.when((Object)this.unorderedList.getParent()).thenReturn((Object)ulParent);
        this.workbenchMenuStandardNavBarView.addContextMenuItem("menuId", "contextMenuId", "labelContext", null, null, null);
        this.workbenchMenuStandardNavBarView.addMenuItem("menuId", "label", null, null, null);
        this.workbenchMenuStandardNavBarView.selectMenuItem("menuId");
        ((NavbarNav)Mockito.verify((Object)this.navbarNav)).add((Widget)this.anchorListItem);
        ((AnchorListItem)Mockito.verify((Object)this.anchorListItem)).setText("label");
        ((UnorderedList)Mockito.verify((Object)this.unorderedList)).setVisible(true);
        ((Widget)Mockito.verify((Object)ulParent)).addStyleName("uf-perspective-context-menu-container");
    }

    @Test
    public void testClearContextMenu() {
        String menuId = "menuId";
        Mockito.when((Object)this.navbarNav.iterator()).thenReturn(Collections.emptyList().iterator());
        Mockito.when((Object)this.listItem.getParent()).thenReturn(Mockito.mock(Widget.class));
        this.workbenchMenuStandardNavBarView.addContextMenuItem("menuId", "contextMenuItemId", "labelContextMenu", null, null, null);
        this.workbenchMenuStandardNavBarView.addContextGroupMenuItem("menuId", "contextGroupMenuId", "labelContextGroup", null);
        this.workbenchMenuStandardNavBarView.clearContextMenu();
        Assert.assertTrue((boolean)this.workbenchMenuStandardNavBarView.getContextContainerWidgetMap().isEmpty());
        Assert.assertTrue((boolean)this.workbenchMenuStandardNavBarView.getMenuItemContextWidgetMap().isEmpty());
        ((AnchorListItem)Mockito.verify((Object)this.anchorListItem)).clear();
        ((AnchorListItem)Mockito.verify((Object)this.anchorListItem)).removeFromParent();
        ((DropDownMenu)Mockito.verify((Object)this.dropDownMenu)).clear();
        ((DropDownMenu)Mockito.verify((Object)this.dropDownMenu)).removeFromParent();
    }

    @Test
    public void testClear() {
        this.workbenchMenuStandardNavBarView.getContextContainerWidgetMap().put("key", Mockito.mock(ComplexPanel.class));
        this.workbenchMenuStandardNavBarView.getMenuItemContextWidgetMap().put("key", Mockito.mock(ComplexPanel.class));
        this.workbenchMenuStandardNavBarView.clear();
        ((NavbarNav)Mockito.verify((Object)this.navbarNav)).clear();
        Assert.assertTrue((boolean)this.workbenchMenuStandardNavBarView.getContextContainerWidgetMap().isEmpty());
        Assert.assertTrue((boolean)this.workbenchMenuStandardNavBarView.getMenuItemContextWidgetMap().isEmpty());
    }
}

