/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.widgets;

import java.util.Arrays;
import java.util.stream.Stream;
import org.jboss.errai.common.client.dom.DOMTokenList;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Document;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.NodeList;
import org.jboss.errai.common.client.dom.Span;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.client.views.pfly.widgets.InlineNotification;

@RunWith(value=MockitoJUnitRunner.class)
public class InlineNotificationTest {
    @Mock
    Div alert;
    @Mock
    Span message;
    @Mock
    Span icon;
    @Mock
    Document document;
    @InjectMocks
    InlineNotification notification;

    @Test
    public void testType() {
        DOMTokenList alertDomTokenList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)this.alert.getClassList()).thenReturn((Object)alertDomTokenList);
        DOMTokenList iconDomTokenList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)this.icon.getClassList()).thenReturn((Object)iconDomTokenList);
        this.notification.setType(InlineNotification.InlineNotificationType.SUCCESS);
        ((DOMTokenList)Mockito.verify((Object)alertDomTokenList)).add(InlineNotification.InlineNotificationType.SUCCESS.getCssClass());
        ((DOMTokenList)Mockito.verify((Object)iconDomTokenList)).add(InlineNotification.InlineNotificationType.SUCCESS.getIcon());
    }

    @Test
    public void testPreviousTypeIsCleared() {
        DOMTokenList alertDomTokenList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)this.alert.getClassList()).thenReturn((Object)alertDomTokenList);
        DOMTokenList iconDomTokenList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)this.icon.getClassList()).thenReturn((Object)iconDomTokenList);
        Mockito.when((Object)alertDomTokenList.contains(ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)iconDomTokenList.contains(ArgumentMatchers.anyString())).thenReturn((Object)true);
        this.notification.setType(InlineNotification.InlineNotificationType.SUCCESS);
        Stream.of(InlineNotification.InlineNotificationType.values()).forEach(availableType -> {
            ((DOMTokenList)Mockito.verify((Object)alertDomTokenList)).remove(availableType.getCssClass());
            ((DOMTokenList)Mockito.verify((Object)iconDomTokenList)).remove(availableType.getIcon());
        });
    }

    @Test
    public void testMessage() {
        String msg = "message";
        this.notification.setMessage("message");
        ((Span)Mockito.verify((Object)this.message)).setTextContent("message");
    }

    @Test
    public void testMessages() {
        HTMLElement htmlElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)htmlElement.getClassList()).thenReturn((Object)((DOMTokenList)Mockito.mock(DOMTokenList.class)));
        Mockito.when((Object)this.document.createElement(ArgumentMatchers.anyString())).thenReturn((Object)htmlElement);
        Mockito.when((Object)this.message.getChildNodes()).thenReturn((Object)((NodeList)Mockito.mock(NodeList.class)));
        this.notification.setMessage(Arrays.asList("message"));
        ((Span)Mockito.verify((Object)this.message)).appendChild((Node)ArgumentMatchers.any(Node.class));
        ((Document)Mockito.verify((Object)this.document)).createElement("li");
        ((Document)Mockito.verify((Object)this.document)).createElement("ul");
    }
}

