/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.listbar;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.listbar.PartListDropdown;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.workbench.model.PartDefinition;

@RunWith(value=GwtMockitoTestRunner.class)
public class PartListDropdownTest {
    @Spy
    @InjectMocks
    PartListDropdown dropdown;

    @Test
    public void selectPartShouldMakeItDraggableOnlyIfDnDIsEnable() {
        Assert.assertTrue((boolean)this.dropdown.isDndEnabled());
        this.dropdown.selectPart((PartDefinition)Mockito.mock(PartDefinition.class));
        ((PartListDropdown)Mockito.verify((Object)this.dropdown)).makeDraggable((Widget)ArgumentMatchers.any(), (WorkbenchPartPresenter.View)ArgumentMatchers.any());
    }

    @Test
    public void selectPartShouldNeverMakeItDraggableIfDnDIsDisable() {
        this.dropdown.disableDragAndDrop();
        Assert.assertTrue((!this.dropdown.isDndEnabled() ? 1 : 0) != 0);
        this.dropdown.selectPart((PartDefinition)Mockito.mock(PartDefinition.class));
        ((PartListDropdown)Mockito.verify((Object)this.dropdown, (VerificationMode)Mockito.never())).makeDraggable((Widget)ArgumentMatchers.any(), (WorkbenchPartPresenter.View)ArgumentMatchers.any());
    }
}

