/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.widgets;

import org.jboss.errai.common.client.dom.HTMLElement;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.widgets.ErrorPopup;

@RunWith(value=MockitoJUnitRunner.class)
public class ErrorPopupTest {
    private static final String MESSAGE = "MESSAGE";
    private static final String DETAIL = "DETAIL";
    private static final String SHOW_DETAIL_LABEL = "SHOW_DETAIL_LABEL";
    private static final String CLOSE_DETAIL_LABEL = "CLOSE_DETAIL_LABEL";
    @Mock
    private HTMLElement inlineNotification;
    @Mock
    private HTMLElement standardNotification;
    @Mock
    private ErrorPopup.View view;
    private ErrorPopup popup;

    @Before
    public void setUp() {
        Mockito.when((Object)this.view.getInlineNotification()).thenReturn((Object)this.inlineNotification);
        Mockito.when((Object)this.view.getStandardNotification()).thenReturn((Object)this.standardNotification);
        Mockito.when((Object)this.view.getShowDetailLabel()).thenReturn((Object)SHOW_DETAIL_LABEL);
        Mockito.when((Object)this.view.getCloseDetailLabel()).thenReturn((Object)CLOSE_DETAIL_LABEL);
        this.popup = (ErrorPopup)Mockito.spy((Object)new ErrorPopup(this.view));
        this.popup.init();
        ((ErrorPopup.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.popup);
    }

    @Test
    public void testShowError() {
        this.popup.showError(MESSAGE);
        ((ErrorPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.times((int)1))).showError(MESSAGE, ErrorPopup.DisplayMode.PATTERN_FLY);
    }

    @Test
    public void testShowErrorStandard() {
        this.popup.showError(MESSAGE, ErrorPopup.DisplayMode.STANDARD);
        this.verifyStandardNotificationWasSet(MESSAGE);
        ((ErrorPopup.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setDetailValue("");
        ((ErrorPopup.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showDetailPanel(false);
        ((ErrorPopup.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).show();
    }

    @Test
    public void testShowErrorPatternFly() {
        this.popup.showError(MESSAGE, ErrorPopup.DisplayMode.PATTERN_FLY);
        this.verifyInlineNotificationWasSet(MESSAGE);
        ((ErrorPopup.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setDetailValue("");
        ((ErrorPopup.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showDetailPanel(false);
        ((ErrorPopup.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).show();
    }

    @Test
    public void testShowErrorWithDetail() {
        this.popup.showError(MESSAGE, DETAIL);
        ((ErrorPopup)Mockito.verify((Object)this.popup, (VerificationMode)Mockito.times((int)1))).showError(MESSAGE, DETAIL, ErrorPopup.DisplayMode.PATTERN_FLY);
    }

    @Test
    public void testShowErrorStandardWithDetail() {
        this.popup.showError(MESSAGE, DETAIL, ErrorPopup.DisplayMode.STANDARD);
        this.verifyStandardNotificationWasSet(MESSAGE);
        ((ErrorPopup.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setDetailValue(DETAIL);
        ((ErrorPopup.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showDetailPanel(true);
        ((ErrorPopup.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).show();
    }

    @Test
    public void testShowErrorPatternFlyWithDetail() {
        this.popup.showError(MESSAGE, DETAIL, ErrorPopup.DisplayMode.PATTERN_FLY);
        this.verifyInlineNotificationWasSet(MESSAGE);
        ((ErrorPopup.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setDetailValue(DETAIL);
        ((ErrorPopup.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showDetailPanel(true);
        ((ErrorPopup.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).show();
    }

    private void verifyStandardNotificationWasSet(String message) {
        ((ErrorPopup.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setNotification(this.standardNotification);
        ((ErrorPopup.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setStandardNotificationValue(message);
        ((ErrorPopup.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setNotification(this.inlineNotification);
        ((ErrorPopup.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setInlineNotificationValue((String)Mockito.any());
    }

    private void verifyInlineNotificationWasSet(String message) {
        ((ErrorPopup.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setNotification(this.inlineNotification);
        ((ErrorPopup.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setInlineNotificationValue(message);
        ((ErrorPopup.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setNotification(this.standardNotification);
        ((ErrorPopup.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setStandardNotificationValue((String)Mockito.any());
    }

    @Test
    public void testOnOK() {
        this.popup.onOk();
        ((ErrorPopup.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hide();
    }

    @Test
    public void testOnClose() {
        this.popup.onClose();
        ((ErrorPopup.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hide();
    }

    @Test
    public void testOnDetailWhenDetailCollapsed() {
        Mockito.when((Object)this.view.isDetailCollapsed()).thenReturn((Object)true);
        this.popup.onDetail();
        ((ErrorPopup.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setCollapseDetailIcon(false);
        ((ErrorPopup.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setDetailLabel(CLOSE_DETAIL_LABEL);
    }

    @Test
    public void testOnDetailWhenDetailNotCollapsed() {
        Mockito.when((Object)this.view.isDetailCollapsed()).thenReturn((Object)false);
        this.popup.onDetail();
        ((ErrorPopup.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setCollapseDetailIcon(true);
        ((ErrorPopup.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setDetailLabel(SHOW_DETAIL_LABEL);
    }
}

