/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import org.junit.Assert;
import org.junit.Test;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.mvp.ActivityBeansCacheUnitTestWrapper;

public class ActivityBeansCacheTest {
    @Test
    public void initShouldCacheSplashScreen() throws Exception {
        ActivityBeansCacheUnitTestWrapper cache = new ActivityBeansCacheUnitTestWrapper();
        cache.mockSplashScreenBehaviour();
        cache.init();
        Assert.assertEquals((Object)cache.getMockDef(), (Object)cache.getActivity(cache.getIdMock()));
        Assert.assertTrue((boolean)cache.getSplashScreens().contains(cache.getSplashScreenActivity()));
    }

    @Test
    public void initShouldCacheActivityById() throws Exception {
        ActivityBeansCacheUnitTestWrapper cache = new ActivityBeansCacheUnitTestWrapper();
        cache.mockSplashScreenBehaviour();
        cache.init();
        Assert.assertEquals((Object)cache.getMockDef(), (Object)cache.getActivity(cache.getIdMock()));
    }

    @Test(expected=RuntimeException.class)
    public void initShouldNotAllowTwoIdenticalsActivities() throws Exception {
        ActivityBeansCacheUnitTestWrapper cache = new ActivityBeansCacheUnitTestWrapper();
        cache.mockSplashScreenBehaviour();
        cache.duplicateActivity();
        cache.init();
    }

    @Test
    public void initShouldCacheOtherActivities() throws Exception {
        ActivityBeansCacheUnitTestWrapper cache = new ActivityBeansCacheUnitTestWrapper();
        cache.mockActivityBehaviour();
        cache.init();
        Assert.assertFalse((boolean)cache.getActivities().isEmpty());
    }

    @Test
    public void initShouldOrderActivityByPriority() throws Exception {
        ActivityBeansCacheUnitTestWrapper cache = new ActivityBeansCacheUnitTestWrapper();
        int priorityActivityOne = Integer.MIN_VALUE;
        int priorityActivityTwo = Integer.MAX_VALUE;
        cache.createActivitiesAndMetaInfo(priorityActivityOne, priorityActivityTwo);
        ActivityBeansCache.ActivityAndMetaInfo firstActivityOnList = cache.getActivities().get(0);
        ActivityBeansCache.ActivityAndMetaInfo secondActivityOnList = cache.getActivities().get(1);
        Assert.assertEquals((long)priorityActivityOne, (long)firstActivityOnList.getPriority());
        Assert.assertEquals((long)priorityActivityTwo, (long)secondActivityOnList.getPriority());
        cache.sortActivitiesByPriority();
        firstActivityOnList = cache.getActivities().get(0);
        secondActivityOnList = cache.getActivities().get(1);
        Assert.assertEquals((long)priorityActivityTwo, (long)firstActivityOnList.getPriority());
        Assert.assertEquals((long)priorityActivityOne, (long)secondActivityOnList.getPriority());
    }
}

