/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import java.util.HashSet;
import javax.enterprise.event.Event;
import org.hamcrest.Matcher;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.AcceptItem;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.BaseWorkbenchTest;
import org.uberfire.client.mvp.MockWorkbenchEditorActivity;
import org.uberfire.client.mvp.PathPlaceRequestUnitTestWrapper;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceManagerImplUnitTestWrapper;
import org.uberfire.client.mvp.WorkbenchEditorActivity;
import org.uberfire.client.workbench.events.SelectPlaceEvent;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.PanelDefinition;

public class AbstractWorkbenchEditorActivityTest
extends BaseWorkbenchTest {
    @Test
    public void testGoToOnePlace() throws Exception {
        String uri = "a/path/to/somewhere";
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PathPlaceRequestUnitTestWrapper somewhere = new PathPlaceRequestUnitTestWrapper(path);
        ((ObservablePath)Mockito.doReturn((Object)"a/path/to/somewhere").when((Object)path)).toURI();
        MockWorkbenchEditorActivity activity = new MockWorkbenchEditorActivity((PlaceManager)this.placeManager);
        final WorkbenchEditorActivity spy = (WorkbenchEditorActivity)Mockito.spy((Object)((Object)activity));
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)somewhere)).thenReturn((Object)new HashSet<Activity>(1){
            {
                super(x0);
                this.add(spy);
            }
        });
        this.placeManager = new PlaceManagerImplUnitTestWrapper((Activity)spy, this.panelManager, (Event<SelectPlaceEvent>)this.selectWorkbenchPartEvent);
        PanelDefinition root = this.panelManager.getRoot();
        this.placeManager.goTo((PlaceRequest)somewhere, root);
        ((WorkbenchEditorActivity)Mockito.verify((Object)spy)).launch((AcceptItem)Matchers.any(AcceptItem.class), (PlaceRequest)Matchers.eq((Object)((Object)somewhere)), (Command)Matchers.isNull(Command.class));
        ((WorkbenchEditorActivity)Mockito.verify((Object)spy)).onStartup((ObservablePath)Matchers.argThat((Matcher)new EqualPaths(path)), (PlaceRequest)Matchers.eq((Object)((Object)somewhere)));
        ((WorkbenchEditorActivity)Mockito.verify((Object)spy)).onOpen();
        ((WorkbenchEditorActivity)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).launch((AcceptItem)Matchers.any(AcceptItem.class), (PlaceRequest)Matchers.eq((Object)((Object)somewhere)), (Command)Matchers.isNull(Command.class));
        ((Event)Mockito.verify((Object)this.selectWorkbenchPartEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(SelectPlaceEvent.class));
    }

    @Test
    public void testGoToOnePlaceTwice() throws Exception {
        String uri = "a/path/to/somewhere";
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PathPlaceRequestUnitTestWrapper somewhere = new PathPlaceRequestUnitTestWrapper(path);
        PlaceRequest somewhereTheSame = somewhere.clone();
        ((ObservablePath)Mockito.doReturn((Object)"a/path/to/somewhere").when((Object)path)).toURI();
        MockWorkbenchEditorActivity activity = new MockWorkbenchEditorActivity((PlaceManager)this.placeManager);
        final WorkbenchEditorActivity spy = (WorkbenchEditorActivity)Mockito.spy((Object)((Object)activity));
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)somewhere)).thenReturn((Object)new HashSet<Activity>(1){
            {
                super(x0);
                this.add(spy);
            }
        });
        Mockito.when((Object)this.activityManager.getActivities(somewhereTheSame)).thenReturn((Object)new HashSet<Activity>(1){
            {
                super(x0);
                this.add(spy);
            }
        });
        this.placeManager = new PlaceManagerImplUnitTestWrapper((Activity)spy, this.panelManager, (Event<SelectPlaceEvent>)this.selectWorkbenchPartEvent);
        PanelDefinition root = this.panelManager.getRoot();
        this.placeManager.goTo((PlaceRequest)somewhere, root);
        this.placeManager.goTo(somewhereTheSame, root);
        ((WorkbenchEditorActivity)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).launch((AcceptItem)Matchers.any(AcceptItem.class), (PlaceRequest)Matchers.eq((Object)((Object)somewhere)), (Command)Matchers.isNull(Command.class));
        ((WorkbenchEditorActivity)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).onStartup((ObservablePath)Matchers.argThat((Matcher)new EqualPaths(path)), (PlaceRequest)Matchers.eq((Object)((Object)somewhere)));
        ((WorkbenchEditorActivity)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).onOpen();
        ((Event)Mockito.verify((Object)this.selectWorkbenchPartEvent, (VerificationMode)Mockito.times((int)2))).fire(Matchers.any(SelectPlaceEvent.class));
    }

    @Test
    public void testGoToTwoDifferentPlaces() throws Exception {
        String uri1 = "a/path/to/somewhere";
        String uri2 = "a/path/to/somewhere/else";
        ObservablePath path1 = (ObservablePath)Mockito.mock(ObservablePath.class);
        ((ObservablePath)Mockito.doReturn((Object)"a/path/to/somewhere").when((Object)path1)).toURI();
        PathPlaceRequestUnitTestWrapper somewhere = new PathPlaceRequestUnitTestWrapper(path1);
        MockWorkbenchEditorActivity activity1 = new MockWorkbenchEditorActivity((PlaceManager)this.placeManager);
        final WorkbenchEditorActivity spy1 = (WorkbenchEditorActivity)Mockito.spy((Object)((Object)activity1));
        ObservablePath path2 = (ObservablePath)Mockito.mock(ObservablePath.class);
        ((ObservablePath)Mockito.doReturn((Object)"a/path/to/somewhere/else").when((Object)path2)).toURI();
        PathPlaceRequestUnitTestWrapper somewhereElse = new PathPlaceRequestUnitTestWrapper(path2);
        MockWorkbenchEditorActivity activity2 = new MockWorkbenchEditorActivity((PlaceManager)this.placeManager);
        final WorkbenchEditorActivity spy2 = (WorkbenchEditorActivity)Mockito.spy((Object)((Object)activity2));
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)somewhere)).thenReturn((Object)new HashSet<Activity>(1){
            {
                super(x0);
                this.add(spy1);
            }
        });
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)somewhereElse)).thenReturn((Object)new HashSet<Activity>(1){
            {
                super(x0);
                this.add(spy2);
            }
        });
        this.placeManager = new PlaceManagerImplUnitTestWrapper((Activity)spy1, this.panelManager, (Event<SelectPlaceEvent>)this.selectWorkbenchPartEvent);
        PanelDefinition root = this.panelManager.getRoot();
        this.placeManager.goTo((PlaceRequest)somewhere, root);
        this.placeManager = new PlaceManagerImplUnitTestWrapper((Activity)spy2, this.panelManager, (Event<SelectPlaceEvent>)this.selectWorkbenchPartEvent);
        this.placeManager.goTo((PlaceRequest)somewhereElse, root);
        ((WorkbenchEditorActivity)Mockito.verify((Object)spy1, (VerificationMode)Mockito.times((int)1))).launch((AcceptItem)Matchers.any(AcceptItem.class), (PlaceRequest)Matchers.eq((Object)((Object)somewhere)), (Command)Matchers.isNull(Command.class));
        ((WorkbenchEditorActivity)Mockito.verify((Object)spy1, (VerificationMode)Mockito.times((int)1))).onStartup((ObservablePath)Matchers.argThat((Matcher)new EqualPaths(path1)), (PlaceRequest)Matchers.eq((Object)((Object)somewhere)));
        ((WorkbenchEditorActivity)Mockito.verify((Object)spy1, (VerificationMode)Mockito.times((int)1))).onOpen();
        ((WorkbenchEditorActivity)Mockito.verify((Object)spy2, (VerificationMode)Mockito.times((int)1))).launch((AcceptItem)Matchers.any(AcceptItem.class), (PlaceRequest)Matchers.eq((Object)((Object)somewhereElse)), (Command)Matchers.isNull(Command.class));
        ((WorkbenchEditorActivity)Mockito.verify((Object)spy2, (VerificationMode)Mockito.times((int)1))).onStartup((ObservablePath)Matchers.argThat((Matcher)new EqualPaths(path2)), (PlaceRequest)Matchers.eq((Object)((Object)somewhereElse)));
        ((WorkbenchEditorActivity)Mockito.verify((Object)spy2, (VerificationMode)Mockito.times((int)1))).onOpen();
        ((Event)Mockito.verify((Object)this.selectWorkbenchPartEvent, (VerificationMode)Mockito.times((int)2))).fire(Matchers.any(SelectPlaceEvent.class));
    }

    private class EqualPaths
    extends ArgumentMatcher<ObservablePath> {
        private Path path;

        private EqualPaths(ObservablePath path) {
            this.path = path;
        }

        public boolean matches(Object argument) {
            if (argument instanceof ObservablePath) {
                ObservablePath that = (ObservablePath)argument;
                return that.toURI().equals(this.path.toURI());
            }
            return false;
        }
    }
}

