/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels.impl;

import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.panels.impl.StaticWorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.impl.StaticWorkbenchPanelViewUnitTestWrapper;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.client.workbench.widgets.panel.StaticFocusedResizePanel;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class StaticWorkbenchPanelViewTest {
    private StaticWorkbenchPanelViewUnitTestWrapper view;
    private StaticWorkbenchPanelPresenter presenter;
    @GwtMock
    private PanelManager panelManager;
    @GwtMock
    private PlaceManager placeManager;

    @Before
    public void setup() {
        this.view = new StaticWorkbenchPanelViewUnitTestWrapper();
        this.presenter = new StaticWorkbenchPanelPresenter(this.view, this.panelManager, null, null){

            public void onResize(int width, int height) {
            }
        };
        this.view.setupMocks(this.presenter, this.placeManager);
    }

    @Test
    public void addPresenterOnInit() {
        this.view.init(this.presenter);
        Assert.assertEquals((Object)this.presenter, (Object)this.view.getPresenter());
    }

    @Test
    public void checkEventsOnInstantiating() {
        Assert.assertTrue((boolean)this.view.initWidgetCalled);
    }

    @Test
    public void verifyClearDelegation() {
        this.view.clear();
        ((StaticFocusedResizePanel)Mockito.verify((Object)this.view.getPanel())).clear();
    }

    @Test
    public void addPartToPanelWhenPartViewIsNull() {
        this.view.mockPanelGetPartView(null);
        WorkbenchPartPresenter.View viewWbPartPresenter = (WorkbenchPartPresenter.View)Mockito.mock(WorkbenchPartPresenter.View.class);
        this.view.addPart(viewWbPartPresenter);
        ((StaticFocusedResizePanel)Mockito.verify((Object)this.view.getPanel())).setPart(viewWbPartPresenter);
    }

    @Test
    public void addPart() {
        WorkbenchPartPresenter.View viewWbPartPresenter = (WorkbenchPartPresenter.View)Mockito.mock(WorkbenchPartPresenter.View.class);
        this.view.mockPanelGetPartView(viewWbPartPresenter);
        this.view.addPart(viewWbPartPresenter);
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).tryClosePlace((PlaceRequest)Mockito.any(PlaceRequest.class), (Command)Mockito.any(Command.class));
    }

    @Test
    public void removePart() {
        this.view.removePart(null);
        ((StaticFocusedResizePanel)Mockito.verify((Object)this.view.getPanel())).clear();
    }

    @Test
    public void onResize() {
        int width = 42;
        int height = 10;
        this.view.mockWidget(42, 10);
        this.view.onResize();
        ((StaticFocusedResizePanel)Mockito.verify((Object)this.view.getPanel())).setPixelSize(42, 10);
        Assert.assertTrue((boolean)this.view.resizeSuperCalled);
        Assert.assertTrue((boolean)this.view.setPixelSizeCalledRightParameters);
    }
}

