/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels.impl;

import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.panels.impl.SimpleWorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.impl.SimpleWorkbenchPanelViewUnitTestWrapper;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchDragAndDropManager;
import org.uberfire.client.workbench.widgets.listbar.ListBarWidget;
import org.uberfire.client.workbench.widgets.panel.RequiresResizeFlowPanel;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class SimpleWorkbenchPanelViewTest {
    private SimpleWorkbenchPanelViewUnitTestWrapper view;
    private SimpleWorkbenchPanelPresenter presenter;
    @GwtMock
    private PanelManager panelManager;
    @GwtMock
    private ListBarWidget listBar;
    @GwtMock
    private RequiresResizeFlowPanel container;
    @GwtMock
    private WorkbenchDragAndDropManager dndManager;

    @Before
    public void setup() {
        this.view = new SimpleWorkbenchPanelViewUnitTestWrapper();
        this.presenter = new SimpleWorkbenchPanelPresenter(this.view, this.panelManager, null, null){

            public void onResize(int width, int height) {
            }
        };
        this.view.setupMocks(this.listBar, this.container, this.dndManager, this.presenter);
    }

    @Test
    public void addPresenterOnInit() {
        this.view.init(this.presenter);
        Assert.assertEquals((Object)this.presenter, (Object)this.view.getPresenter());
    }

    @Test
    public void setupDragAndDrop() {
        this.view.setupDragAndDrop();
        ((ListBarWidget)Mockito.verify((Object)this.listBar)).setDndManager((WorkbenchDragAndDropManager)Mockito.eq((Object)this.dndManager));
        ((ListBarWidget)Mockito.verify((Object)this.listBar)).setup(false, false);
        ((ListBarWidget)Mockito.verify((Object)this.listBar)).addSelectionHandler((SelectionHandler)Mockito.any(SelectionHandler.class));
        ((ListBarWidget)Mockito.verify((Object)this.listBar)).addSelectionHandler((SelectionHandler)Mockito.any(SelectionHandler.class));
        ((ListBarWidget)Mockito.verify((Object)this.listBar)).addOnFocusHandler((Command)Mockito.any(Command.class));
    }

    @Test
    public void onResizeShouldOnlyResizeParentWhenWidthAndHeightAreZero() {
        String width = "10";
        String height = "100";
        this.view.setWidth("10");
        this.view.setHeight("100");
        this.view.onResize();
        ((ListBarWidget)Mockito.verify((Object)this.listBar, (VerificationMode)Mockito.never())).onResize();
    }

    @Test
    public void onResize() {
        this.view.changeWidgetSizeMock(10, 10);
        this.view.onResize();
        ((ListBarWidget)Mockito.verify((Object)this.listBar)).onResize();
    }
}

