/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels.impl;

import com.google.common.collect.ImmutableMap;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.panels.WorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.impl.AbstractDockingWorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.impl.AbstractWorkbenchPanelPresenterTest;
import org.uberfire.client.workbench.panels.impl.SimpleWorkbenchPanelPresenter;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;

public abstract class AbstractDockingWorkbenchPanelPresenterTest
extends AbstractWorkbenchPanelPresenterTest {
    @Mock
    protected PanelManager panelManager;

    abstract AbstractDockingWorkbenchPanelPresenter<?> getPresenterToTest();

    @Test
    public void removingLastPartFromPanelShouldRemovePanelToo() throws Exception {
        WorkbenchPanelPresenter westChildPanelPresenter = (WorkbenchPanelPresenter)Mockito.mock(SimpleWorkbenchPanelPresenter.class);
        WorkbenchPanelPresenter parentPanelPresenter = (WorkbenchPanelPresenter)Mockito.mock(SimpleWorkbenchPanelPresenter.class);
        AbstractDockingWorkbenchPanelPresenter<?> panelPresenter = this.getPresenterToTest();
        panelPresenter.setDefinition(this.panelPresenterPanelDefinition);
        panelPresenter.setParent(parentPanelPresenter);
        panelPresenter.addPanel(westChildPanelPresenter, (Position)CompassPosition.WEST);
        panelPresenter.addPart(this.mockPartPresenter);
        panelPresenter.removePart(this.mockPartPresenter.getDefinition());
        ((PanelManager)Mockito.verify((Object)this.panelManager)).removeWorkbenchPanel(this.panelPresenterPanelDefinition);
    }

    @Test
    public void childrenOfRemovedPanelsShouldBeRescued() throws Exception {
        WorkbenchPanelPresenter westChildPanelPresenter = (WorkbenchPanelPresenter)Mockito.mock(SimpleWorkbenchPanelPresenter.class);
        WorkbenchPanelPresenter westChildChild = (WorkbenchPanelPresenter)Mockito.mock(SimpleWorkbenchPanelPresenter.class);
        Mockito.when((Object)westChildPanelPresenter.getPanels()).thenReturn((Object)ImmutableMap.of((Object)CompassPosition.WEST, (Object)westChildChild));
        AbstractDockingWorkbenchPanelPresenter<?> panelPresenter = this.getPresenterToTest();
        panelPresenter.addPanel(westChildPanelPresenter, (Position)CompassPosition.WEST);
        panelPresenter.removePanel(westChildPanelPresenter);
        Assert.assertEquals((Object)CompassPosition.WEST, (Object)panelPresenter.positionOf(westChildChild));
    }
}

