/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.widgets.tab;

import com.github.gwtbootstrap.client.ui.DropdownTab;
import com.github.gwtbootstrap.client.ui.Tab;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchDragAndDropManager;
import org.uberfire.client.workbench.widgets.tab.UberTabPanel;
import org.uberfire.client.workbench.widgets.tab.UberTabPanelUnitTestWrapper;

@RunWith(value=GwtMockitoTestRunner.class)
public class UberTabPanelTest {
    private UberTabPanelUnitTestWrapper uberTabPanel;
    private WorkbenchPartPresenter.View presenter;
    @GwtMock
    private WorkbenchDragAndDropManager dndManager;
    @Mock
    private PanelManager panelManager;

    @Before
    public void setup() {
        this.uberTabPanel = new UberTabPanelUnitTestWrapper(this.panelManager);
        this.uberTabPanel.setupMocks(this.dndManager);
        this.presenter = (WorkbenchPartPresenter.View)GWT.create(WorkbenchPartPresenter.View.class);
    }

    @Test
    public void assertInstanciationSequence() {
        Assert.assertNotNull((Object)this.uberTabPanel.tabPanel);
    }

    @Test
    public void createTabTest() {
        Tab tab = this.uberTabPanel.createTab(this.presenter, true, 1, 1);
        ((Tab)Mockito.verify((Object)tab)).addClickHandler((ClickHandler)Mockito.any(ClickHandler.class));
        ((Tab)Mockito.verify((Object)tab)).add((Widget)Mockito.any(Widget.class));
        Assert.assertEquals((Object)tab.asTabLink(), this.uberTabPanel.tabIndex.get(this.presenter));
        Assert.assertEquals((Object)this.presenter, this.uberTabPanel.tabInvertedIndex.get(tab.asTabLink()));
        ((WorkbenchDragAndDropManager)Mockito.verify((Object)this.dndManager)).makeDraggable((IsWidget)Mockito.any(WorkbenchPartPresenter.View.class), (IsWidget)Mockito.any(Widget.class));
        Class<Widget> closeButtom = Widget.class;
        ((Tab)Mockito.verify((Object)tab)).addDecorate((Widget)Mockito.any(closeButtom));
    }

    @Test
    public void addPartTest() {
        this.uberTabPanel.addPart(this.presenter);
        ((UberTabPanel.ResizeTabPanel)Mockito.verify((Object)this.uberTabPanel.tabPanelSpy)).add((IsWidget)Mockito.any(Tab.class));
    }

    @Test
    public void addPartLastTabisDrownTabTest() {
        this.uberTabPanel.setLastTabIsDropdownTab(true);
        this.uberTabPanel.addPart(this.presenter);
        ((UberTabPanel.ResizeTabPanel)Mockito.verify((Object)this.uberTabPanel.tabPanelSpy)).add((Widget)Mockito.any(DropdownTab.class));
    }
}

