/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels.impl;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.SimpleLayoutPanel;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.panels.WorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.impl.AbstractDockingWorkbenchPanelView;
import org.uberfire.client.workbench.panels.impl.AbstractDockingWorkbenchPanelViewTest;
import org.uberfire.client.workbench.panels.impl.SimpleWorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.impl.SimpleWorkbenchPanelViewUnitTestWrapper;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchDragAndDropManager;
import org.uberfire.client.workbench.widgets.listbar.ListBarWidget;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class SimpleWorkbenchPanelViewTest
extends AbstractDockingWorkbenchPanelViewTest {
    @InjectMocks
    private SimpleWorkbenchPanelViewUnitTestWrapper view;
    @Mock
    private PanelManager panelManager;
    @Mock
    private ListBarWidget listBar;
    private final Element listBarElement = (Element)Mockito.mock(Element.class);
    private final Style listBarElementStyle = (Style)Mockito.mock(Style.class);
    private SimpleWorkbenchPanelPresenter presenter;

    @Before
    public void setup() {
        Mockito.when((Object)this.listBar.asWidget()).thenReturn((Object)this.listBar);
        Mockito.when((Object)this.listBar.getElement()).thenReturn((Object)this.listBarElement);
        Mockito.when((Object)this.listBarElement.getStyle()).thenReturn((Object)this.listBarElementStyle);
        this.presenter = (SimpleWorkbenchPanelPresenter)Mockito.mock(SimpleWorkbenchPanelPresenter.class);
        this.view.setup();
        this.view.init((WorkbenchPanelPresenter)this.presenter);
    }

    @Override
    protected AbstractDockingWorkbenchPanelView<?> getViewToTest() {
        return this.view;
    }

    @Test
    public void shouldAddPresenterOnInit() {
        Assert.assertEquals((Object)this.presenter, (Object)this.view.getPresenter());
    }

    @Test
    public void shouldSetupDragAndDropOnListBar() {
        ((ListBarWidget)Mockito.verify((Object)this.listBar)).setDndManager((WorkbenchDragAndDropManager)Mockito.eq((Object)this.dndManager));
        ((ListBarWidget)Mockito.verify((Object)this.listBar)).setup(false, false);
        ((ListBarWidget)Mockito.verify((Object)this.listBar)).addSelectionHandler((SelectionHandler)Mockito.any(SelectionHandler.class));
        ((ListBarWidget)Mockito.verify((Object)this.listBar)).addSelectionHandler((SelectionHandler)Mockito.any(SelectionHandler.class));
        ((ListBarWidget)Mockito.verify((Object)this.listBar)).addOnFocusHandler((Command)Mockito.any(Command.class));
    }

    @Test
    public void shouldPropagateResizeWhenAttached() {
        this.view.forceAttachedState(true);
        this.view.setPixelSize(10, 10);
        this.view.onResize();
        ((SimpleWorkbenchPanelPresenter)Mockito.verify((Object)this.presenter)).onResize(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue());
        ((SimpleLayoutPanel)Mockito.verify((Object)this.topLevelWidget)).onResize();
    }

    @Test
    public void shouldNotPropagateResizeWhenNotAttached() {
        this.view.forceAttachedState(false);
        this.view.setPixelSize(10, 10);
        this.view.onResize();
        ((SimpleWorkbenchPanelPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).onResize(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue());
        ((SimpleLayoutPanel)Mockito.verify((Object)this.topLevelWidget)).onResize();
    }
}

