/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench;

import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.lang.annotation.Annotation;
import java.util.Collections;
import javax.enterprise.event.Event;
import org.jboss.errai.bus.client.api.ClientMessageBus;
import org.jboss.errai.bus.client.framework.ClientMessageBusImpl;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.Workbench;
import org.uberfire.client.workbench.WorkbenchLayout;
import org.uberfire.client.workbench.events.ApplicationReadyEvent;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchDragAndDropManager;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchPickupDragController;

@RunWith(value=GwtMockitoTestRunner.class)
public class WorkbenchStartupTest {
    @InjectMocks
    Workbench workbench;
    @Mock
    SyncBeanManager bm;
    @Mock
    WorkbenchPickupDragController dragController;
    @Mock
    WorkbenchDragAndDropManager dndManager;
    @Mock
    PanelManager panelManager;
    @Mock
    StubAppReadyEventSource appReadyEvent;
    @Mock
    User identity;
    @Mock(extraInterfaces={ClientMessageBus.class})
    ClientMessageBusImpl bus;
    @Mock
    WorkbenchLayout layout;

    @Before
    public void setup() {
        Mockito.when((Object)this.bm.lookupBeans((Class)Mockito.any(Class.class))).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.dragController.getBoundaryPanel()).thenReturn((Object)new AbsolutePanel());
    }

    @Test
    public void shouldNotStartWhenBlocked() throws Exception {
        ((StubAppReadyEventSource)Mockito.verify((Object)this.appReadyEvent, (VerificationMode)Mockito.never())).fire((ApplicationReadyEvent)Mockito.any(ApplicationReadyEvent.class));
        this.workbench.addStartupBlocker(WorkbenchStartupTest.class);
        this.workbench.startIfNotBlocked();
        ((StubAppReadyEventSource)Mockito.verify((Object)this.appReadyEvent, (VerificationMode)Mockito.never())).fire((ApplicationReadyEvent)Mockito.any(ApplicationReadyEvent.class));
    }

    @Test
    public void shouldStartWhenUnblocked() throws Exception {
        this.workbench.addStartupBlocker(WorkbenchStartupTest.class);
        this.workbench.removeStartupBlocker(WorkbenchStartupTest.class);
        ((StubAppReadyEventSource)Mockito.verify((Object)this.appReadyEvent, (VerificationMode)Mockito.times((int)1))).fire((ApplicationReadyEvent)Mockito.any(ApplicationReadyEvent.class));
    }

    @Test
    public void shouldStartOnAfterInitIfNeverBlocked() throws Exception {
        this.workbench.startIfNotBlocked();
        ((StubAppReadyEventSource)Mockito.verify((Object)this.appReadyEvent, (VerificationMode)Mockito.times((int)1))).fire((ApplicationReadyEvent)Mockito.any(ApplicationReadyEvent.class));
    }

    public static class StubAppReadyEventSource
    implements Event<ApplicationReadyEvent> {
        public void fire(ApplicationReadyEvent event) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public Event<ApplicationReadyEvent> select(Annotation ... qualifiers) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public <U extends ApplicationReadyEvent> Event<U> select(Class<U> subtype, Annotation ... qualifiers) {
            throw new UnsupportedOperationException("Not implemented.");
        }
    }
}

