/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels.support;

import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.uberfire.commons.data.Pair;
import org.uberfire.workbench.model.PartDefinition;

@ApplicationScoped
public class PartManager {
    private final Map<PartDefinition, Widget> widgets = new HashMap<PartDefinition, Widget>();
    private Pair<PartDefinition, Widget> activePart;

    public Pair<PartDefinition, Widget> getActivePart() {
        return this.activePart;
    }

    public boolean hasActivePart() {
        return this.activePart != null;
    }

    public void registerPart(PartDefinition partDef, Widget w) {
        if (this.widgets.containsKey(partDef)) {
            throw new IllegalArgumentException("Part already registered: " + partDef.getPlace().getIdentifier());
        }
        this.widgets.put(partDef, w);
    }

    public void removePart(PartDefinition partDef) {
        if (partDef.equals(this.activePart)) {
            this.activePart = null;
        }
        this.widgets.remove(partDef);
    }

    public void clearParts() {
        this.widgets.clear();
        this.activePart = null;
    }

    public boolean hasPart(PartDefinition partDef) {
        return this.widgets.containsKey(partDef);
    }

    public Widget selectPart(PartDefinition partDef) {
        if (!this.hasPart(partDef)) {
            throw new IllegalArgumentException("Unknown part: " + partDef.getPlace().getIdentifier());
        }
        Widget w = this.widgets.get(partDef);
        this.activePart = new Pair((Object)partDef, (Object)w);
        return (Widget)this.activePart.getK2();
    }
}

