/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels;

import org.uberfire.client.mvp.UberView;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.mvp.Command;

public class MaximizeToggleButtonPresenter {
    private final View view;
    private boolean maximized;
    private Command maximizeCommand;
    private Command unmaximizeCommand;

    public MaximizeToggleButtonPresenter(View view) {
        this.view = (View)PortablePreconditions.checkNotNull((String)"view", (Object)view);
        view.init(this);
    }

    public Command getMaximizeCommand() {
        return this.maximizeCommand;
    }

    public void setMaximizeCommand(Command maximizeCommand) {
        this.maximizeCommand = maximizeCommand;
    }

    public Command getUnmaximizeCommand() {
        return this.unmaximizeCommand;
    }

    public void setUnmaximizeCommand(Command unmaximizeCommand) {
        this.unmaximizeCommand = unmaximizeCommand;
    }

    public boolean isMaximized() {
        return this.maximized;
    }

    public void setMaximized(boolean maximized) {
        this.maximized = maximized;
        this.view.setMaximized(maximized);
    }

    public void handleClick() {
        boolean wasMaximized = this.maximized;
        this.setMaximized(!wasMaximized);
        if (wasMaximized) {
            if (this.unmaximizeCommand != null) {
                this.unmaximizeCommand.execute();
            }
        } else if (this.maximizeCommand != null) {
            this.maximizeCommand.execute();
        }
    }

    public View getView() {
        return this.view;
    }

    public void setVisible(boolean b) {
        this.view.setVisible(b);
    }

    public static interface View
    extends UberView<MaximizeToggleButtonPresenter> {
        public void setMaximized(boolean var1);

        public void setVisible(boolean var1);
    }
}

