/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.widgets.notifications;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RootPanel;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.WorkbenchActivity;
import org.uberfire.client.workbench.events.ClosePlaceEvent;
import org.uberfire.client.workbench.events.PlaceLostFocusEvent;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;

@ApplicationScoped
public class NotificationManager {
    private final SyncBeanManager iocManager;
    private final Map<PlaceRequest, View> notificationsContainerViewMap = new HashMap<PlaceRequest, View>();
    private final PlaceManager placeManager;
    private final PlaceRequest rootPlaceRequest = new DefaultPlaceRequest("org.uberfire.client.workbench.widgets.notifications.root");

    @Inject
    public NotificationManager(SyncBeanManager iocManager, PlaceManager placeManager) {
        this.iocManager = (SyncBeanManager)PortablePreconditions.checkNotNull((String)"iocManager", (Object)iocManager);
        this.placeManager = (PlaceManager)PortablePreconditions.checkNotNull((String)"placeManager", (Object)placeManager);
    }

    public void addNotification(@Observes NotificationEvent event) {
        IOCBeanDef containerViewBeanDef;
        PlaceRequest placeRequest = event.getPlaceRequest();
        RootPanel notificationsContainer = RootPanel.get();
        if (placeRequest == null) {
            placeRequest = this.rootPlaceRequest;
        } else {
            Activity activity = this.placeManager.getActivity(placeRequest);
            if (activity instanceof WorkbenchActivity) {
                notificationsContainer = ((WorkbenchActivity)activity).getWidget();
            }
        }
        View notificationsContainerView = this.notificationsContainerViewMap.get(placeRequest);
        if (notificationsContainerView == null && (containerViewBeanDef = this.iocManager.lookupBean(View.class, new Annotation[0])) != null) {
            notificationsContainerView = (View)containerViewBeanDef.getInstance();
            notificationsContainerView.setContainer((IsWidget)notificationsContainer);
            if (event.getInitialTopOffset() != null) {
                notificationsContainerView.setInitialSpacing(event.getInitialTopOffset());
            }
            this.notificationsContainerViewMap.put(placeRequest, notificationsContainerView);
        }
        if (notificationsContainerView == null) {
            return;
        }
        if (!event.isSingleton() || !notificationsContainerView.isShowing(event)) {
            HideNotificationCommand hideCommand = new HideNotificationCommand(notificationsContainerView);
            NotificationPopupHandle handle = notificationsContainerView.show(event, hideCommand);
            hideCommand.setHandle(handle);
        }
    }

    public void onClosePlaceEvent(@Observes ClosePlaceEvent event) {
        PlaceRequest placeRequest = event.getPlace();
        if (placeRequest == null) {
            return;
        }
        View view = this.notificationsContainerViewMap.remove(placeRequest);
        if (view != null) {
            view.hideAll();
        }
    }

    public void onPlaceLostFocus(@Observes PlaceLostFocusEvent event) {
        View view = this.notificationsContainerViewMap.get(event.getPlace());
        if (view != null) {
            view.hideAll();
        }
    }

    private class HideNotificationCommand
    implements Command {
        private NotificationPopupHandle handle;
        private final View notificationContainerView;

        HideNotificationCommand(View notificationContainerView) {
            this.notificationContainerView = (View)PortablePreconditions.checkNotNull((String)"notificationContainerView", (Object)notificationContainerView);
        }

        public void execute() {
            if (this.handle == null) {
                throw new IllegalStateException("The show() method hasn't returned a handle yet!");
            }
            this.notificationContainerView.hide(this.handle);
        }

        void setHandle(NotificationPopupHandle handle) {
            this.handle = handle;
        }
    }

    public static interface View {
        public void setContainer(IsWidget var1);

        public void setInitialSpacing(int var1);

        public NotificationPopupHandle show(NotificationEvent var1, Command var2);

        public void hide(NotificationPopupHandle var1);

        public void hideAll();

        public boolean isShowing(NotificationEvent var1);
    }

    public static interface NotificationPopupHandle {
    }
}

