/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.widgets.menu;

import com.google.common.collect.Sets;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.client.workbench.widgets.menu.WorkbenchMenuBarPresenter;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuPosition;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkbenchMenuBarPresenterTest {
    @Mock
    private PerspectiveManager perspectiveManager;
    @Mock
    protected AuthorizationManager authzManager;
    @Mock
    protected User identity;
    @Mock
    private ActivityManager activityManager;
    @Mock
    private WorkbenchMenuBarPresenter.View view;
    @InjectMocks
    private WorkbenchMenuBarPresenter presenter;

    @Test
    public void testAddCurrentPerspective() {
        String perspectiveId = "perspectiveId";
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"test").perspective("perspectiveId")).endMenu()).build();
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest("perspectiveId");
        PerspectiveActivity perspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        Mockito.when((Object)perspectiveActivity.getPlace()).thenReturn((Object)placeRequest);
        Mockito.when((Object)this.perspectiveManager.getCurrentPerspective()).thenReturn((Object)perspectiveActivity);
        Mockito.when((Object)this.authzManager.authorize((Resource)Mockito.any(Resource.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).selectMenuItem("perspectiveId");
    }

    @Test
    public void testAddPerspective() {
        String perspectiveId = "perspectiveId";
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"test").perspective("perspectiveId")).endMenu()).build();
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest("anyId");
        PerspectiveActivity perspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        Mockito.when((Object)perspectiveActivity.getPlace()).thenReturn((Object)placeRequest);
        Mockito.when((Object)this.perspectiveManager.getCurrentPerspective()).thenReturn((Object)perspectiveActivity);
        Mockito.when((Object)this.authzManager.authorize((Resource)Mockito.any(Resource.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).selectMenuItem("perspectiveId");
    }

    @Test
    public void testPerspectiveChangeEvent() {
        String perspectiveId = "perspectiveId";
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"test").perspective("perspectiveId")).endMenu()).build();
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest("perspectiveId");
        PerspectiveActivity perspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        PerspectiveChange perspectiveChange = new PerspectiveChange((PlaceRequest)placeRequest, null, null, "perspectiveId");
        Mockito.when((Object)perspectiveActivity.getPlace()).thenReturn((Object)placeRequest);
        Mockito.when((Object)this.authzManager.authorize((Resource)Mockito.any(Resource.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        this.presenter.onPerspectiveChange(perspectiveChange);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).selectMenuItem("perspectiveId");
    }

    @Test
    public void testAddMenuWithPermission() {
        String perspectiveId = "perspectiveId";
        String label = "perspectiveLabel";
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"perspectiveLabel").perspective("perspectiveId")).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((AuthorizationManager)Mockito.verify((Object)this.authzManager)).authorize((Resource)menus.getItems().get(0), this.identity);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).addMenuItem((String)Mockito.eq((Object)"perspectiveId"), (String)Mockito.eq((Object)"perspectiveLabel"), (String)Mockito.isNull(String.class), (Command)Mockito.any(Command.class), (MenuPosition)Mockito.any(MenuPosition.class));
    }

    @Test
    public void testAddMenuWithoutPermission() {
        String perspectiveId = "perspectiveId";
        String label = "perspectiveLabel";
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"perspectiveLabel").perspective("perspectiveId")).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)false);
        this.presenter.addMenus(menus);
        ((AuthorizationManager)Mockito.verify((Object)this.authzManager)).authorize((Resource)menus.getItems().get(0), this.identity);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addMenuItem((String)Mockito.eq((Object)"perspectiveId"), (String)Mockito.eq((Object)"perspectiveLabel"), (String)Mockito.isNull(String.class), (Command)Mockito.any(Command.class), (MenuPosition)Mockito.any(MenuPosition.class));
    }

    @Test
    public void testAddContextMenuWithPermission() {
        String perspectiveId = "perspectiveId";
        String label = "perspectiveLabel";
        String contextLabel = "contextLabel";
        MenuPosition position = MenuPosition.LEFT;
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"perspectiveLabel").perspective("perspectiveId")).endMenu()).build();
        Menus contextMenus = ((MenuFactory.Builder)MenuFactory.newSimpleItem((String)"contextLabel").endMenu()).build();
        PerspectiveActivity activity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        Mockito.when((Object)activity.getIdentifier()).thenReturn((Object)"perspectiveId");
        Mockito.when((Object)activity.getMenus()).thenReturn((Object)contextMenus);
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)contextMenus.getItems().get(0), this.identity)).thenReturn((Object)true);
        Mockito.when((Object)this.activityManager.getActivities(PerspectiveActivity.class)).thenReturn((Object)Sets.newHashSet((Object[])new PerspectiveActivity[]{activity}));
        this.presenter.addMenus(menus);
        ((AuthorizationManager)Mockito.verify((Object)this.authzManager)).authorize((Resource)menus.getItems().get(0), this.identity);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).addMenuItem((String)Mockito.eq((Object)"perspectiveId"), (String)Mockito.eq((Object)"perspectiveLabel"), (String)Mockito.isNull(String.class), (Command)Mockito.any(Command.class), (MenuPosition)Mockito.eq((Object)position));
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).addContextMenuItem((String)Mockito.eq((Object)"perspectiveId"), Mockito.anyString(), (String)Mockito.eq((Object)"contextLabel"), (String)Mockito.isNull(String.class), (Command)Mockito.any(Command.class), (MenuPosition)Mockito.eq((Object)position));
    }

    @Test
    public void testAddContextMenuWithoutPermission() {
        String perspectiveId = "perspectiveId";
        String label = "perspectiveLabel";
        String contextLabel = "contextLabel";
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"perspectiveLabel").perspective("perspectiveId")).endMenu()).build();
        Menus contextMenus = ((MenuFactory.Builder)MenuFactory.newSimpleItem((String)"contextLabel").endMenu()).build();
        PerspectiveActivity activity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        Mockito.when((Object)activity.getIdentifier()).thenReturn((Object)"perspectiveId");
        Mockito.when((Object)activity.getMenus()).thenReturn((Object)contextMenus);
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)contextMenus.getItems().get(0), this.identity)).thenReturn((Object)false);
        Mockito.when((Object)this.activityManager.getActivities(PerspectiveActivity.class)).thenReturn((Object)Sets.newHashSet((Object[])new PerspectiveActivity[]{activity}));
        this.presenter.addMenus(menus);
        ((AuthorizationManager)Mockito.verify((Object)this.authzManager)).authorize((Resource)menus.getItems().get(0), this.identity);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).addMenuItem((String)Mockito.eq((Object)"perspectiveId"), (String)Mockito.eq((Object)"perspectiveLabel"), (String)Mockito.isNull(String.class), (Command)Mockito.any(Command.class), (MenuPosition)Mockito.any(MenuPosition.class));
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addContextMenuItem(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), (Command)Mockito.any(Command.class), (MenuPosition)Mockito.any(MenuPosition.class));
    }

    @Test
    public void testSetupEnableDisableMenuItemCommand() {
        String label = "command";
        Command command = (Command)Mockito.mock(Command.class);
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"command").respondsWith(command)).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((MenuItem)menus.getItems().get(0)).setEnabled(true);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).enableMenuItem(Mockito.anyString(), Mockito.eq((boolean)true));
        ((MenuItem)menus.getItems().get(0)).setEnabled(false);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).enableMenuItem(Mockito.anyString(), Mockito.eq((boolean)false));
    }

    @Test
    public void testSetupEnableDisableMenuItemPlace() {
        String label = "placeLabel";
        PlaceRequest place = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"placeLabel").place(place)).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((MenuItem)menus.getItems().get(0)).setEnabled(true);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).enableMenuItem(Mockito.anyString(), Mockito.eq((boolean)true));
        ((MenuItem)menus.getItems().get(0)).setEnabled(false);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).enableMenuItem(Mockito.anyString(), Mockito.eq((boolean)false));
    }

    @Test
    public void testSetupEnableDisableMenuItemPerspective() {
        String label = "perspectiveLabel";
        String perspectiveId = "perspectiveId";
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"perspectiveLabel").perspective("perspectiveId")).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((MenuItem)menus.getItems().get(0)).setEnabled(true);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).enableMenuItem(Mockito.anyString(), Mockito.eq((boolean)true));
        ((MenuItem)menus.getItems().get(0)).setEnabled(false);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).enableMenuItem(Mockito.anyString(), Mockito.eq((boolean)false));
    }

    @Test
    public void testSetupEnableDisableContextMenuItem() {
        String label = "perspectiveLabel";
        String contextLabel = "contextLabel";
        String perspectiveId = "perspectiveId";
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"perspectiveLabel").perspective("perspectiveId")).endMenu()).build();
        Menus contextMenus = ((MenuFactory.Builder)MenuFactory.newSimpleItem((String)"contextLabel").endMenu()).build();
        PerspectiveActivity activity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        Mockito.when((Object)activity.getIdentifier()).thenReturn((Object)"perspectiveId");
        Mockito.when((Object)activity.getMenus()).thenReturn((Object)contextMenus);
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)contextMenus.getItems().get(0), this.identity)).thenReturn((Object)true);
        Mockito.when((Object)this.activityManager.getActivities(PerspectiveActivity.class)).thenReturn((Object)Sets.newHashSet((Object[])new PerspectiveActivity[]{activity}));
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((MenuItem)contextMenus.getItems().get(0)).setEnabled(true);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).enableContextMenuItem(Mockito.anyString(), Mockito.eq((boolean)true));
        ((MenuItem)contextMenus.getItems().get(0)).setEnabled(false);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).enableContextMenuItem(Mockito.anyString(), Mockito.eq((boolean)false));
    }

    @Test
    public void testMenuInsertionOrder() {
        String perspectiveId = "perspectiveId";
        String label = "perspectiveLabel";
        Menus firstMenus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"perspectiveLabel").perspective("perspectiveId")).endMenu()).build();
        Menus secondMenus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"perspectiveLabel").orderAll(1)).perspective("perspectiveId")).endMenu()).build();
        Menus thirdMenus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"perspectiveLabel").orderAll(2)).perspective("perspectiveId")).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)firstMenus.getItems().get(0), this.identity)).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)secondMenus.getItems().get(0), this.identity)).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)thirdMenus.getItems().get(0), this.identity)).thenReturn((Object)true);
        this.presenter.addMenus(thirdMenus);
        this.presenter.addMenus(firstMenus);
        this.presenter.addMenus(secondMenus);
        Assert.assertEquals((long)3L, (long)this.presenter.getAddedMenus().size());
        Assert.assertSame((Object)firstMenus, this.presenter.getAddedMenus().get(0));
        Assert.assertSame((Object)secondMenus, this.presenter.getAddedMenus().get(1));
        Assert.assertSame((Object)thirdMenus, this.presenter.getAddedMenus().get(2));
    }
}

