/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import com.google.common.collect.ImmutableMap;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import javax.enterprise.context.Dependent;
import org.jboss.errai.ioc.client.QualifierUtil;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.SyncBeanManagerImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.backend.vfs.impl.ObservablePathImpl;
import org.uberfire.client.mvp.PlaceRequestHistoryMapperImpl;
import org.uberfire.client.util.MockIOCBeanDef;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class PlaceRequestHistoryMapperImplTest {
    private PlaceRequestHistoryMapperImpl placeRequestHistoryMapper;

    @BeforeClass
    public static void setupBeans() {
        ((SyncBeanManagerImpl)IOC.getBeanManager()).reset();
        IOC.getBeanManager().registerBean(new MockIOCBeanDef<ObservablePath, ObservablePathImpl>(new ObservablePathImpl(), ObservablePath.class, Dependent.class, new HashSet<Annotation>(Arrays.asList(QualifierUtil.DEFAULT_QUALIFIERS)), null, true, new Class[0]));
    }

    @Before
    public void setup() {
        this.placeRequestHistoryMapper = new PlaceRequestHistoryMapperImpl(){

            String urlDecode(String value) {
                try {
                    return URLDecoder.decode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @Test
    public void createPlaceRequest() throws Exception {
        String url = " http://127.0.0.1:8888/org.uberfire.UberfireShowcase/out.16590-4829.erraiBus?z=12&clientId=16590-4829";
        PlaceRequest placeRequest = this.placeRequestHistoryMapper.getPlaceRequest(url);
        Assert.assertEquals((Object)url.substring(0, url.indexOf("?")), (Object)placeRequest.getIdentifier());
        Map parameters = placeRequest.getParameters();
        Assert.assertFalse((boolean)parameters.isEmpty());
        Assert.assertTrue((boolean)parameters.containsKey("z"));
        Assert.assertTrue((boolean)parameters.containsKey("clientId"));
        Assert.assertEquals((Object)"12", parameters.get("z"));
        Assert.assertEquals((Object)"16590-4829", parameters.get("clientId"));
    }

    @Test
    public void createPathPlaceRequest() throws Exception {
        Path path = PathFactory.newPath((String)"file", (String)"default://master@repo/path/to/file");
        PathPlaceRequest placeRequestOriginal = new PathPlaceRequest(path);
        PlaceRequest placeRequest = this.placeRequestHistoryMapper.getPlaceRequest(placeRequestOriginal.getFullIdentifier());
        Assert.assertEquals((Object)placeRequestOriginal.getFullIdentifier(), (Object)placeRequest.getFullIdentifier());
        Assert.assertTrue((boolean)placeRequest.getParameters().isEmpty());
    }

    @Test
    public void createPathPlaceRequestWithSpaces() throws Exception {
        Path path = PathFactory.newPath((String)"Dummy rule.drl", (String)"default://master@uf-playground/mortgages/src/main/resources/org/mortgages/Dummy%20rule.drl");
        PathPlaceRequest placeRequestOriginal = new PathPlaceRequest(path);
        PlaceRequest placeRequest = this.placeRequestHistoryMapper.getPlaceRequest(placeRequestOriginal.getFullIdentifier());
        Assert.assertEquals((Object)placeRequestOriginal.getFullIdentifier(), (Object)placeRequest.getFullIdentifier());
        Assert.assertTrue((boolean)placeRequest.getParameters().isEmpty());
    }

    @Test
    public void identifierAndParametersShouldBeUrlDecoded() throws Exception {
        PlaceRequest placeRequest = this.placeRequestHistoryMapper.getPlaceRequest("place%20id?par%26am%201=value%201");
        Assert.assertEquals((Object)"place id", (Object)placeRequest.getIdentifier());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"par&am 1", (Object)"value 1"), (Object)placeRequest.getParameters());
    }
}

