/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench;

import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import javax.enterprise.event.Event;
import org.jboss.errai.bus.client.api.ClientMessageBus;
import org.jboss.errai.bus.client.framework.ClientMessageBusImpl;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.LayoutSelection;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.Workbench;
import org.uberfire.client.workbench.WorkbenchLayout;
import org.uberfire.client.workbench.events.ApplicationReadyEvent;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchDragAndDropManager;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchPickupDragController;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.PermissionManager;

@RunWith(value=GwtMockitoTestRunner.class)
public class WorkbenchStartupTest {
    @InjectMocks
    @Spy
    Workbench workbench;
    @Mock
    SyncBeanManager bm;
    @Mock
    WorkbenchPickupDragController dragController;
    @Mock
    WorkbenchDragAndDropManager dndManager;
    @Mock
    PanelManager panelManager;
    @Mock
    StubAppReadyEventSource appReadyEvent;
    @Mock
    User identity;
    @Mock(extraInterfaces={ClientMessageBus.class})
    ClientMessageBusImpl bus;
    @Mock
    WorkbenchLayout layout;
    @Mock
    LayoutSelection layoutSelection;
    @Mock
    PermissionManager permissionManager;
    @Mock
    PlaceManager placeManager;
    @Mock
    AuthorizationManager authorizationManager;
    @Mock
    AuthorizationPolicy authorizationPolicy;
    @Mock
    SyncBeanDef<PerspectiveActivity> perspectiveBean1;
    @Mock
    SyncBeanDef<PerspectiveActivity> perspectiveBean2;
    @Mock
    PerspectiveActivity perspectiveActivity1;
    @Mock
    PerspectiveActivity perspectiveActivity2;

    @Before
    public void setup() {
        Mockito.when((Object)this.bm.lookupBeans((Class)Mockito.any(Class.class))).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.dragController.getBoundaryPanel()).thenReturn((Object)new AbsolutePanel());
        ((Workbench)Mockito.doNothing().when((Object)this.workbench)).addLayoutToRootPanel((WorkbenchLayout)Mockito.any(WorkbenchLayout.class));
        Mockito.when((Object)this.permissionManager.getAuthorizationPolicy()).thenReturn((Object)this.authorizationPolicy);
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Mockito.any(Resource.class), (User)Mockito.any(User.class))).thenReturn((Object)true);
        Mockito.when((Object)this.bm.lookupBeans(PerspectiveActivity.class)).thenReturn(Arrays.asList(this.perspectiveBean1, this.perspectiveBean2));
        Mockito.when((Object)this.perspectiveBean1.getInstance()).thenReturn((Object)this.perspectiveActivity1);
        Mockito.when((Object)this.perspectiveBean2.getInstance()).thenReturn((Object)this.perspectiveActivity2);
        Mockito.when((Object)this.perspectiveActivity1.getIdentifier()).thenReturn((Object)"perspective1");
        Mockito.when((Object)this.perspectiveActivity2.getIdentifier()).thenReturn((Object)"perspective2");
        Mockito.when((Object)this.perspectiveActivity2.isDefault()).thenReturn((Object)true);
    }

    @Test
    public void shouldNotStartWhenBlocked() throws Exception {
        ((StubAppReadyEventSource)Mockito.verify((Object)this.appReadyEvent, (VerificationMode)Mockito.never())).fire((ApplicationReadyEvent)Mockito.any(ApplicationReadyEvent.class));
        this.workbench.addStartupBlocker(WorkbenchStartupTest.class);
        this.workbench.startIfNotBlocked();
        ((StubAppReadyEventSource)Mockito.verify((Object)this.appReadyEvent, (VerificationMode)Mockito.never())).fire((ApplicationReadyEvent)Mockito.any(ApplicationReadyEvent.class));
    }

    @Test
    public void shouldStartWhenUnblocked() throws Exception {
        this.workbench.addStartupBlocker(WorkbenchStartupTest.class);
        this.workbench.removeStartupBlocker(WorkbenchStartupTest.class);
        ((StubAppReadyEventSource)Mockito.verify((Object)this.appReadyEvent, (VerificationMode)Mockito.times((int)1))).fire((ApplicationReadyEvent)Mockito.any(ApplicationReadyEvent.class));
    }

    @Test
    public void shouldStartOnAfterInitIfNeverBlocked() throws Exception {
        this.workbench.startIfNotBlocked();
        ((StubAppReadyEventSource)Mockito.verify((Object)this.appReadyEvent, (VerificationMode)Mockito.times((int)1))).fire((ApplicationReadyEvent)Mockito.any(ApplicationReadyEvent.class));
    }

    @Test
    public void goToHomePerspective() throws Exception {
        Mockito.when((Object)this.authorizationPolicy.getHomePerspective(this.identity)).thenReturn((Object)"perspective1");
        this.workbench.startIfNotBlocked();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)new DefaultPlaceRequest(this.perspectiveActivity1.getIdentifier()));
    }

    @Test
    public void goToDefaultPerspective() throws Exception {
        Mockito.when((Object)this.perspectiveActivity1.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)this.perspectiveActivity2.isDefault()).thenReturn((Object)false);
        this.workbench.startIfNotBlocked();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)new DefaultPlaceRequest(this.perspectiveActivity1.getIdentifier()));
    }

    @Test
    public void goToNoWhere() throws Exception {
        Mockito.when((Object)this.perspectiveActivity2.isDefault()).thenReturn((Object)false);
        this.workbench.startIfNotBlocked();
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).goTo((PlaceRequest)Mockito.any(PlaceRequest.class));
    }

    public static class StubAppReadyEventSource
    implements Event<ApplicationReadyEvent> {
        public void fire(ApplicationReadyEvent event) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public Event<ApplicationReadyEvent> select(Annotation ... qualifiers) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public <U extends ApplicationReadyEvent> Event<U> select(Class<U> subtype, Annotation ... qualifiers) {
            throw new UnsupportedOperationException("Not implemented.");
        }
    }
}

