/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels.impl;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.panels.impl.StaticWorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.impl.StaticWorkbenchPanelView;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.client.workbench.widgets.panel.StaticFocusedResizePanel;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;

@RunWith(value=GwtMockitoTestRunner.class)
public class StaticWorkbenchPanelViewTest {
    @InjectMocks
    private StaticWorkbenchPanelView view;
    private final StaticWorkbenchPanelPresenter presenter = (StaticWorkbenchPanelPresenter)Mockito.mock(StaticWorkbenchPanelPresenter.class);
    @Mock
    private PanelManager panelManager;
    @Mock
    private PlaceManager placeManager;
    @Mock(answer=Answers.RETURNS_MOCKS)
    private StaticFocusedResizePanel panel;

    @Before
    public void setup() {
        this.view.postConstruct();
        this.view.init(this.presenter);
    }

    @Test
    public void addPresenterOnInit() {
        Assert.assertEquals((Object)this.presenter, (Object)this.view.getPresenter());
    }

    @Test
    public void addPartToPanelWhenPartViewIsNull() {
        WorkbenchPartPresenter.View viewWbPartPresenter = (WorkbenchPartPresenter.View)Mockito.mock(WorkbenchPartPresenter.View.class);
        Mockito.when((Object)this.panel.getPartView()).thenReturn(null);
        this.view.addPart(viewWbPartPresenter);
        ((StaticFocusedResizePanel)Mockito.verify((Object)this.panel)).setPart(viewWbPartPresenter);
    }

    @Test
    public void removeContainedPart() {
        WorkbenchPartPresenter mockPresenter = (WorkbenchPartPresenter)Mockito.mock(WorkbenchPartPresenter.class);
        WorkbenchPartPresenter.View mockPartView = (WorkbenchPartPresenter.View)Mockito.mock(WorkbenchPartPresenter.View.class);
        PartDefinitionImpl mockPartDefinition = new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("mockPlace"));
        Mockito.when((Object)mockPartView.getPresenter()).thenReturn((Object)mockPresenter);
        Mockito.when((Object)mockPresenter.getDefinition()).thenReturn((Object)mockPartDefinition);
        Mockito.when((Object)this.view.panel.getPartView()).thenReturn(null);
        this.view.addPart(mockPartView);
        Mockito.when((Object)this.view.panel.getPartView()).thenReturn((Object)mockPartView);
        boolean removed = this.view.removePart((PartDefinition)mockPartDefinition);
        Assert.assertTrue((boolean)removed);
        ((StaticFocusedResizePanel)Mockito.verify((Object)this.panel)).clear();
    }

    @Test
    public void removeNonContainedPart() {
        WorkbenchPartPresenter mockPresenter = (WorkbenchPartPresenter)Mockito.mock(WorkbenchPartPresenter.class);
        WorkbenchPartPresenter.View mockPartView = (WorkbenchPartPresenter.View)Mockito.mock(WorkbenchPartPresenter.View.class);
        PartDefinitionImpl mockPartDefinition = new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("mock1"));
        Mockito.when((Object)mockPartView.getPresenter()).thenReturn((Object)mockPresenter);
        Mockito.when((Object)mockPresenter.getDefinition()).thenReturn((Object)mockPartDefinition);
        WorkbenchPartPresenter mockPresenter2 = (WorkbenchPartPresenter)Mockito.mock(WorkbenchPartPresenter.class);
        WorkbenchPartPresenter.View mockPartView2 = (WorkbenchPartPresenter.View)Mockito.mock(WorkbenchPartPresenter.View.class);
        PartDefinitionImpl mockPartDefinition2 = new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("mock2"));
        Mockito.when((Object)mockPartView2.getPresenter()).thenReturn((Object)mockPresenter2);
        Mockito.when((Object)mockPresenter2.getDefinition()).thenReturn((Object)mockPartDefinition2);
        Mockito.when((Object)this.view.panel.getPartView()).thenReturn(null);
        this.view.addPart(mockPartView);
        Mockito.when((Object)this.view.panel.getPartView()).thenReturn((Object)mockPartView);
        boolean removed = this.view.removePart((PartDefinition)mockPartDefinition2);
        Assert.assertFalse((boolean)removed);
        ((StaticFocusedResizePanel)Mockito.verify((Object)this.panel, (VerificationMode)Mockito.never())).clear();
    }

    @Test
    public void onResize() {
        int width = 42;
        int height = 10;
        this.view.setPixelSize(42, 10);
        this.view.onResize();
        ((StaticFocusedResizePanel)Mockito.verify((Object)this.panel)).onResize();
    }

    @Test
    public void getPartsShouldReturnCurrentPart() {
        Assert.assertFalse((boolean)this.view.getParts().isEmpty());
    }
}

