/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels.impl;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.panels.DockingWorkbenchPanelView;
import org.uberfire.client.workbench.panels.WorkbenchPanelView;
import org.uberfire.client.workbench.panels.impl.AbstractDockingWorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.impl.AbstractDockingWorkbenchPanelPresenterTest;
import org.uberfire.client.workbench.panels.impl.ClosableSimpleWorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.impl.SinglePartPanelHelper;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.PartDefinition;

@RunWith(value=MockitoJUnitRunner.class)
public class ClosableSimpleWorkbenchPanelPresenterTest
extends AbstractDockingWorkbenchPanelPresenterTest {
    @Mock(name="view")
    protected DockingWorkbenchPanelView<ClosableSimpleWorkbenchPanelPresenter> view;
    @Mock
    private PlaceManager placeManager;
    @InjectMocks
    ClosableSimpleWorkbenchPanelPresenter presenter;

    @Before
    public void setUp2() {
        this.presenter.init();
        this.presenter.setDefinition(this.panelPresenterPanelDefinition);
    }

    @Override
    AbstractDockingWorkbenchPanelPresenter<?> getPresenterToTest() {
        return this.presenter;
    }

    @Test
    public void initShouldBindPresenterToView() {
        ((DockingWorkbenchPanelView)Mockito.verify(this.view)).init((Object)this.presenter);
    }

    @Test
    public void addPartTest() {
        WorkbenchPartPresenter part = (WorkbenchPartPresenter)Mockito.mock(WorkbenchPartPresenter.class);
        Mockito.when((Object)part.getDefinition()).thenReturn(Mockito.mock(PartDefinition.class));
        this.presenter.addPart(part);
        ((DockingWorkbenchPanelView)Mockito.verify(this.view)).addPart((WorkbenchPartPresenter.View)Mockito.any());
    }

    @Test
    public void addPartTwiceShouldCloseOtherPartTest() {
        final SinglePartPanelHelper singlePartPanelHelper = (SinglePartPanelHelper)Mockito.mock(SinglePartPanelHelper.class);
        ClosableSimpleWorkbenchPanelPresenter presenter = new ClosableSimpleWorkbenchPanelPresenter((WorkbenchPanelView)this.view, (PerspectiveManager)Mockito.mock(PerspectiveManager.class), this.placeManager){

            SinglePartPanelHelper createSinglePartPanelHelper() {
                return singlePartPanelHelper;
            }
        };
        presenter.init();
        presenter.setDefinition(this.panelPresenterPanelDefinition);
        Mockito.when((Object)singlePartPanelHelper.hasNoParts()).thenReturn((Object)false);
        WorkbenchPartPresenter part2 = (WorkbenchPartPresenter)Mockito.mock(WorkbenchPartPresenter.class);
        Mockito.when((Object)part2.getDefinition()).thenReturn(Mockito.mock(PartDefinition.class));
        presenter.addPart(part2);
        ((SinglePartPanelHelper)Mockito.verify((Object)singlePartPanelHelper)).closeFirstPartAndAddNewOne((Command)Mockito.any(Command.class));
    }
}

