/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels.impl;

import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.workbench.panels.MaximizeToggleButtonPresenter;
import org.uberfire.client.workbench.panels.impl.AbstractDockingWorkbenchPanelView;
import org.uberfire.client.workbench.panels.impl.AbstractDockingWorkbenchPanelViewTest;
import org.uberfire.client.workbench.panels.impl.MultiListWorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.impl.MultiListWorkbenchPanelView;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.client.workbench.widgets.listbar.ListBarWidget;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class MultiListWorkbenchPanelViewTest
extends AbstractDockingWorkbenchPanelViewTest {
    @Mock
    ListBarWidget listBar;
    @Mock
    MaximizeToggleButtonPresenter maximizeButton;
    @Mock
    MultiListWorkbenchPanelPresenter presenter;
    @InjectMocks
    MultiListWorkbenchPanelView view;

    @Override
    protected AbstractDockingWorkbenchPanelView<?> getViewToTest() {
        return this.view;
    }

    @Before
    public void setup() {
        Mockito.when((Object)this.listBar.getMaximizeButton()).thenReturn((Object)this.maximizeButton);
        final AtomicLong parts = new AtomicLong();
        ((ListBarWidget)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                parts.incrementAndGet();
                return null;
            }
        }).when((Object)this.listBar)).addPart((WorkbenchPartPresenter.View)Matchers.any(WorkbenchPartPresenter.View.class));
        Mockito.when((Object)this.listBar.getPartsSize()).thenAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock invocation) throws Throwable {
                return parts.intValue();
            }
        });
    }

    @Test
    public void setupWidget() {
        this.view.setupWidget();
        ((ListBarWidget)Mockito.verify((Object)this.listBar)).addSelectionHandler((SelectionHandler)Matchers.any(SelectionHandler.class));
        ((ListBarWidget)Mockito.verify((Object)this.listBar)).addOnFocusHandler((Command)Matchers.any(Command.class));
        ((ListBarWidget)Mockito.verify((Object)this.listBar)).disableDnd();
        ((MaximizeToggleButtonPresenter)Mockito.verify((Object)this.maximizeButton)).setVisible(true);
        ((MaximizeToggleButtonPresenter)Mockito.verify((Object)this.maximizeButton)).setMaximizeCommand((Command)Matchers.any(Command.class));
        ((MaximizeToggleButtonPresenter)Mockito.verify((Object)this.maximizeButton)).setUnmaximizeCommand((Command)Matchers.any(Command.class));
    }

    @Test
    public void shouldPropagateOnResize() {
        this.view.onResize();
        RequiresResize viewChild = (RequiresResize)this.view.getWidget();
        ((RequiresResize)Mockito.verify((Object)viewChild, (VerificationMode)Mockito.times((int)1))).onResize();
    }

    @Test
    public void shouldAddMultipleParts() {
        Assert.assertEquals((long)0L, (long)this.listBar.getPartsSize());
        ((ListBarWidget)Mockito.verify((Object)this.listBar, (VerificationMode)Mockito.never())).disableClosePart();
        this.view.addPart((WorkbenchPartPresenter.View)Mockito.mock(WorkbenchPartPresenter.View.class));
        ((ListBarWidget)Mockito.verify((Object)this.listBar)).addPart((WorkbenchPartPresenter.View)Matchers.any(WorkbenchPartPresenter.View.class));
        this.view.addPart((WorkbenchPartPresenter.View)Mockito.mock(WorkbenchPartPresenter.View.class));
        ((ListBarWidget)Mockito.verify((Object)this.listBar, (VerificationMode)Mockito.times((int)2))).addPart((WorkbenchPartPresenter.View)Matchers.any(WorkbenchPartPresenter.View.class));
        Assert.assertEquals((long)2L, (long)this.listBar.getPartsSize());
    }
}

