/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.authz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.client.authz.PerspectiveTreeProvider;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.resources.i18n.PermissionTreeI18n;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.client.authz.tree.LoadOptions;
import org.uberfire.security.client.authz.tree.PermissionNode;
import org.uberfire.security.client.authz.tree.PermissionTree;
import org.uberfire.security.client.authz.tree.impl.DefaultLoadOptions;
import org.uberfire.security.impl.authz.DefaultPermissionManager;

@RunWith(value=MockitoJUnitRunner.class)
public class PerspectiveTreeProviderTest {
    @Mock
    ActivityBeansCache activityBeansCache;
    @Mock
    PermissionTreeI18n i18n;
    @Mock
    PermissionTree permissionTree;
    PermissionManager permissionManager;
    PerspectiveTreeProvider provider;
    PermissionNode root;

    @Before
    public void setUp() {
        ArrayList<SyncBeanDef> beanDefs = new ArrayList<SyncBeanDef>();
        SyncBeanDef bean1 = (SyncBeanDef)Mockito.mock(SyncBeanDef.class);
        SyncBeanDef bean2 = (SyncBeanDef)Mockito.mock(SyncBeanDef.class);
        PerspectiveActivity perspective1 = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        PerspectiveActivity perspective2 = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        Mockito.when((Object)bean1.getInstance()).thenReturn((Object)perspective1);
        Mockito.when((Object)bean2.getInstance()).thenReturn((Object)perspective2);
        Mockito.when((Object)perspective1.getIdentifier()).thenReturn((Object)"Perspective1");
        Mockito.when((Object)perspective2.getIdentifier()).thenReturn((Object)"Perspective2");
        beanDefs.add(bean1);
        beanDefs.add(bean2);
        Mockito.when((Object)this.activityBeansCache.getPerspectiveActivities()).thenReturn(beanDefs);
        this.permissionManager = new DefaultPermissionManager();
        this.provider = new PerspectiveTreeProvider(this.activityBeansCache, this.permissionManager, this.i18n);
        this.provider.setRootNodeName("root");
        this.provider.setPerspectiveName("Perspective1", "A nice perspective");
        this.provider.setPerspectiveName("Perspective2", "Another nice perspective");
        this.root = this.provider.buildRootNode();
        this.root.setPermissionTree(this.permissionTree);
    }

    @Test
    public void testEmpty() {
        DefaultLoadOptions options = new DefaultLoadOptions();
        this.provider.loadChildren(this.root, (LoadOptions)options, children -> Assert.assertEquals((long)children.size(), (long)0L));
    }

    @Test
    public void testIncludedResourceIds() {
        DefaultLoadOptions options = new DefaultLoadOptions();
        options.setResourceIds(Arrays.asList("Perspective1"));
        this.provider.loadChildren(this.root, (LoadOptions)options, children -> Assert.assertEquals((long)children.size(), (long)1L));
    }

    @Test
    public void testExcludedResourceIds() {
        DefaultLoadOptions options = new DefaultLoadOptions();
        options.setResourceIds(Arrays.asList("Perspective1"));
        this.provider.loadChildren(this.root, (LoadOptions)options, children -> Assert.assertEquals((long)children.size(), (long)1L));
    }

    @Test
    public void testExcludedPerspectiveIds() {
        this.provider.excludePerspectiveId("Perspective1");
        DefaultLoadOptions options = new DefaultLoadOptions();
        options.setNodeNamePattern("");
        this.provider.loadChildren(this.root, (LoadOptions)options, children -> Assert.assertEquals((long)children.size(), (long)1L));
    }

    @Test
    public void testNameSearch1() {
        DefaultLoadOptions options = new DefaultLoadOptions();
        options.setNodeNamePattern("nice");
        this.provider.loadChildren(this.root, (LoadOptions)options, children -> Assert.assertEquals((long)children.size(), (long)2L));
    }

    @Test
    public void testNameSearch2() {
        DefaultLoadOptions options = new DefaultLoadOptions();
        options.setNodeNamePattern("another");
        this.provider.loadChildren(this.root, (LoadOptions)options, children -> Assert.assertEquals((long)children.size(), (long)1L));
    }

    @Test
    public void testNameSearch3() {
        DefaultLoadOptions options = new DefaultLoadOptions();
        options.setNodeNamePattern("another");
        this.provider.loadChildren(this.root, (LoadOptions)options, children -> Assert.assertEquals((long)children.size(), (long)1L));
    }

    @Test
    public void testRootNode() {
        Assert.assertEquals((long)this.root.getPermissionList().size(), (long)4L);
        this.checkDependencies(this.root);
    }

    @Test
    public void testChildrenNodes() {
        this.root.expand(children -> {
            for (PermissionNode child : children) {
                Assert.assertEquals((long)child.getPermissionList().size(), (long)3L);
                this.checkDependencies(child);
            }
        });
    }

    protected void checkDependencies(PermissionNode permissionNode) {
        for (Permission permission : permissionNode.getPermissionList()) {
            List dependencies = permissionNode.getDependencies(permission);
            if (permission.getName().startsWith("perspective.read")) {
                Assert.assertEquals((long)dependencies.size(), (long)2L);
                continue;
            }
            Assert.assertNull((Object)dependencies);
        }
    }
}

