/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.event.Event;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.mvp.ActivityBeansCacheUnitTestWrapper;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.WorkbenchScreenActivity;
import org.uberfire.client.workbench.events.NewPerspectiveEvent;
import org.uberfire.client.workbench.type.ClientResourceType;

@RunWith(value=MockitoJUnitRunner.class)
public class ActivityBeansCacheTest {
    @Mock
    private SyncBeanManager iocManager;
    @Mock
    private Event<NewPerspectiveEvent> newPerspectiveEventEvent;
    @InjectMocks
    ActivityBeansCache cache;

    @Test
    public void initShouldCacheSplashScreen() throws Exception {
        ActivityBeansCacheUnitTestWrapper cache = new ActivityBeansCacheUnitTestWrapper();
        cache.mockSplashScreenBehaviour();
        cache.init();
        Assert.assertEquals((Object)cache.getMockDef(), (Object)cache.getActivity(cache.getIdMock()));
        Assert.assertTrue((boolean)cache.getSplashScreens().contains(cache.getSplashScreenActivity()));
    }

    @Test
    public void initShouldCacheActivityById() throws Exception {
        ActivityBeansCacheUnitTestWrapper cache = new ActivityBeansCacheUnitTestWrapper();
        cache.mockSplashScreenBehaviour();
        cache.init();
        Assert.assertEquals((Object)cache.getMockDef(), (Object)cache.getActivity(cache.getIdMock()));
    }

    @Test(expected=RuntimeException.class)
    public void initShouldNotAllowTwoIdenticalsActivities() throws Exception {
        ActivityBeansCacheUnitTestWrapper cache = new ActivityBeansCacheUnitTestWrapper();
        cache.mockSplashScreenBehaviour();
        cache.duplicateActivity();
        cache.init();
    }

    @Test
    public void initShouldCacheOtherActivities() throws Exception {
        ActivityBeansCacheUnitTestWrapper cache = new ActivityBeansCacheUnitTestWrapper();
        cache.mockActivityBehaviour();
        cache.init();
        Assert.assertFalse((boolean)cache.getResourceActivities().isEmpty());
    }

    @Test
    public void initShouldOrderActivityByPriority() throws Exception {
        ActivityBeansCacheUnitTestWrapper cache = new ActivityBeansCacheUnitTestWrapper();
        int priorityActivityOne = Integer.MIN_VALUE;
        int priorityActivityTwo = Integer.MAX_VALUE;
        cache.createActivitiesAndMetaInfo(priorityActivityOne, priorityActivityTwo);
        ActivityBeansCache.ActivityAndMetaInfo firstActivityOnList = cache.getResourceActivities().get(0);
        ActivityBeansCache.ActivityAndMetaInfo secondActivityOnList = cache.getResourceActivities().get(1);
        Assert.assertEquals((long)priorityActivityOne, (long)firstActivityOnList.getPriority());
        Assert.assertEquals((long)priorityActivityTwo, (long)secondActivityOnList.getPriority());
        cache.sortResourceActivitiesByPriority();
        firstActivityOnList = cache.getResourceActivities().get(0);
        secondActivityOnList = cache.getResourceActivities().get(1);
        Assert.assertEquals((long)priorityActivityTwo, (long)firstActivityOnList.getPriority());
        Assert.assertEquals((long)priorityActivityOne, (long)secondActivityOnList.getPriority());
    }

    @Test
    public void activityAndMetaInfoShouldLookupResourceTypesOnRuntime() {
        ClientResourceType clientResourceType = (ClientResourceType)Mockito.mock(ClientResourceType.class);
        SyncBeanDef syncBeanDef = (SyncBeanDef)Mockito.mock(SyncBeanDef.class);
        Mockito.when((Object)syncBeanDef.getInstance()).thenReturn((Object)clientResourceType);
        List<SyncBeanDef> resourceTypeBeans = Arrays.asList(syncBeanDef);
        Mockito.when((Object)this.iocManager.lookupBeans("resource1")).thenReturn(resourceTypeBeans);
        ActivityBeansCache activityBeansCache = this.cache;
        activityBeansCache.getClass();
        ActivityBeansCache.ActivityAndMetaInfo activatedActivityAndMetaInfo = new ActivityBeansCache.ActivityAndMetaInfo(activityBeansCache, (SyncBeanDef)Mockito.mock(SyncBeanDef.class), 0, Arrays.asList("resource1"));
        Assert.assertNull((Object)activatedActivityAndMetaInfo.resourceTypes);
        Assert.assertTrue((!activatedActivityAndMetaInfo.resourceTypesNames.isEmpty() ? 1 : 0) != 0);
        activatedActivityAndMetaInfo.getResourceTypes();
        Assert.assertTrue((activatedActivityAndMetaInfo.resourceTypes.length > 0 ? 1 : 0) != 0);
    }

    @Test(expected=RuntimeException.class)
    public void dynamicLookupOfResourceTypeShouldFailWhenThereIsNoResource() {
        ArrayList resourceTypeBeans = new ArrayList();
        Mockito.when((Object)this.iocManager.lookupBeans("resource1")).thenReturn(resourceTypeBeans);
        ActivityBeansCache activityBeansCache = this.cache;
        activityBeansCache.getClass();
        ActivityBeansCache.ActivityAndMetaInfo activatedActivityAndMetaInfo = new ActivityBeansCache.ActivityAndMetaInfo(activityBeansCache, (SyncBeanDef)Mockito.mock(SyncBeanDef.class), 0, Arrays.asList("resource1"));
        activatedActivityAndMetaInfo.getResourceTypes();
    }

    @Test
    public void addEditorActivityShouldSortResourcesByPriority() {
        String higherPriority = "20000";
        String lowerPriority = "1";
        SyncBeanDef mock = (SyncBeanDef)Mockito.mock(SyncBeanDef.class);
        Mockito.when((Object)mock.getName()).thenReturn((Object)"resource1");
        this.cache.addNewEditorActivity(mock, lowerPriority, "resource");
        SyncBeanDef mock1 = (SyncBeanDef)Mockito.mock(SyncBeanDef.class);
        Mockito.when((Object)mock1.getName()).thenReturn((Object)"resource2");
        this.cache.addNewEditorActivity(mock1, higherPriority, "resource1");
        List resourceActivities = this.cache.getResourceActivities();
        Assert.assertEquals((long)((ActivityBeansCache.ActivityAndMetaInfo)resourceActivities.get(0)).getPriority(), (long)Integer.valueOf(higherPriority).intValue());
    }

    @Test
    public void addEditorActivityShouldAddToActivitiesByID() {
        String resource = "resource";
        SyncBeanDef mock = (SyncBeanDef)Mockito.mock(SyncBeanDef.class);
        Mockito.when((Object)mock.getName()).thenReturn((Object)resource);
        this.cache.addNewEditorActivity(mock, "1", resource);
        Assert.assertTrue((boolean)this.cache.hasActivity(resource));
    }

    @Test
    public void getPerspectiveActivities() {
        SyncBeanDef mock1 = (SyncBeanDef)Mockito.mock(SyncBeanDef.class);
        Mockito.when((Object)mock1.getName()).thenReturn((Object)"perspective2");
        Mockito.when((Object)mock1.isAssignableTo(PerspectiveActivity.class)).thenReturn((Object)true);
        SyncBeanDef mock2 = (SyncBeanDef)Mockito.mock(SyncBeanDef.class);
        Mockito.when((Object)mock2.getName()).thenReturn((Object)"screen");
        Mockito.when((Object)mock2.getType()).thenReturn(WorkbenchScreenActivity.class);
        this.cache.addNewPerspectiveActivity(mock1);
        this.cache.addNewPerspectiveActivity(mock2);
        List perspectiveActivities = this.cache.getPerspectiveActivities();
        Assert.assertEquals((long)perspectiveActivities.size(), (long)1L);
    }
}

