/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.authz;

import java.util.Collections;
import java.util.List;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.client.authz.EditorTreeProvider;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.mvp.WorkbenchEditorActivity;
import org.uberfire.client.resources.i18n.PermissionTreeI18n;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.client.authz.tree.LoadOptions;
import org.uberfire.security.client.authz.tree.PermissionNode;
import org.uberfire.security.client.authz.tree.PermissionTree;
import org.uberfire.security.client.authz.tree.impl.DefaultLoadOptions;
import org.uberfire.security.impl.authz.DefaultPermissionManager;

@RunWith(value=MockitoJUnitRunner.class)
public class EditorTreeProviderTest {
    private static final String EDITOR1_ID = "Editor1";
    private static final String EDITOR2_ID = "Editor2";
    private static final String EDITOR1_NAME = "Editor 1 name";
    private static final String EDITOR2_NAME = "Editor 2 name";
    @Mock
    private ActivityBeansCache activityBeansCache;
    @Mock
    private PermissionTreeI18n i18n;
    @Mock
    private PermissionTree permissionTree;
    private PermissionManager permissionManager;
    private EditorTreeProvider provider;
    private PermissionNode root;

    @Before
    public void setUp() {
        SyncBeanDef<Activity> editor1 = this.makeWorkbenchEditorActivity(EDITOR1_ID);
        SyncBeanDef<Activity> editor2 = this.makeWorkbenchEditorActivity(EDITOR2_ID);
        Mockito.when((Object)this.activityBeansCache.getActivity(EDITOR1_ID)).thenReturn(editor1);
        Mockito.when((Object)this.activityBeansCache.getActivity(EDITOR2_ID)).thenReturn(editor2);
        Mockito.when((Object)this.i18n.editorResourceName()).thenReturn((Object)"Editor Resource name");
        Mockito.when((Object)this.i18n.editorsNodeName()).thenReturn((Object)"Editor Node name");
        this.permissionManager = new DefaultPermissionManager();
        this.provider = new EditorTreeProvider(this.activityBeansCache, this.permissionManager, this.i18n);
        this.root = this.provider.buildRootNode();
        this.root.setPermissionTree(this.permissionTree);
    }

    private SyncBeanDef<Activity> makeWorkbenchEditorActivity(String editorId) {
        SyncBeanDef beanDef = (SyncBeanDef)Mockito.mock(SyncBeanDef.class);
        WorkbenchEditorActivity bean = (WorkbenchEditorActivity)Mockito.mock(WorkbenchEditorActivity.class);
        Mockito.when((Object)beanDef.getInstance()).thenReturn((Object)bean);
        Mockito.when((Object)bean.getIdentifier()).thenReturn((Object)editorId);
        return beanDef;
    }

    @Test
    public void testEmpty() {
        DefaultLoadOptions options = new DefaultLoadOptions();
        this.provider.loadChildren(this.root, (LoadOptions)options, children -> Assert.assertEquals((long)children.size(), (long)0L));
    }

    @Test
    public void testIncludedResourceIds() {
        this.provider.registerEditor(EDITOR1_ID, EDITOR1_NAME);
        DefaultLoadOptions options = new DefaultLoadOptions();
        options.setResourceIds(Collections.singletonList(EDITOR1_ID));
        this.provider.loadChildren(this.root, (LoadOptions)options, children -> Assert.assertEquals((long)children.size(), (long)1L));
    }

    @Test
    public void testRegisterEditor() {
        this.provider.registerEditor(EDITOR1_ID, EDITOR1_NAME);
        DefaultLoadOptions options = new DefaultLoadOptions();
        options.setNodeNamePattern("");
        this.provider.loadChildren(this.root, (LoadOptions)options, children -> Assert.assertEquals((long)children.size(), (long)1L));
    }

    @Test
    public void testNameSearch1() {
        this.provider.registerEditor(EDITOR1_ID, EDITOR1_NAME);
        this.provider.registerEditor(EDITOR2_ID, EDITOR2_NAME);
        DefaultLoadOptions options = new DefaultLoadOptions();
        options.setNodeNamePattern("name");
        this.provider.loadChildren(this.root, (LoadOptions)options, children -> {
            Assert.assertEquals((long)children.size(), (long)2L);
            this.assertContains(EDITOR1_NAME, children);
            this.assertContains(EDITOR2_NAME, children);
        });
    }

    private void assertContains(String editorName, List<PermissionNode> children) {
        Assert.assertTrue((boolean)children.stream().filter(p -> p.getNodeName().equals(editorName)).findFirst().isPresent());
    }

    @Test
    public void testNameSearch2() {
        this.provider.registerEditor(EDITOR1_ID, EDITOR1_NAME);
        this.provider.registerEditor(EDITOR2_ID, EDITOR2_NAME);
        DefaultLoadOptions options = new DefaultLoadOptions();
        options.setNodeNamePattern("1");
        this.provider.loadChildren(this.root, (LoadOptions)options, children -> {
            Assert.assertEquals((long)children.size(), (long)1L);
            Assert.assertEquals((Object)EDITOR1_NAME, (Object)((PermissionNode)children.get(0)).getNodeName());
        });
    }

    @Test
    public void testNameSearch3() {
        this.provider.registerEditor(EDITOR1_ID, EDITOR1_NAME);
        this.provider.registerEditor(EDITOR2_ID, EDITOR2_NAME);
        DefaultLoadOptions options = new DefaultLoadOptions();
        options.setNodeNamePattern("2");
        this.provider.loadChildren(this.root, (LoadOptions)options, children -> {
            Assert.assertEquals((long)children.size(), (long)1L);
            Assert.assertEquals((Object)EDITOR2_NAME, (Object)((PermissionNode)children.get(0)).getNodeName());
        });
    }

    @Test
    public void testRootNode() {
        Assert.assertEquals((long)this.root.getPermissionList().size(), (long)1L);
        this.checkDependencies(this.root);
    }

    @Test
    public void testChildrenNodes() {
        this.root.expand(children -> {
            for (PermissionNode child : children) {
                Assert.assertEquals((long)child.getPermissionList().size(), (long)3L);
                this.checkDependencies(child);
            }
        });
    }

    protected void checkDependencies(PermissionNode permissionNode) {
        for (Permission permission : permissionNode.getPermissionList()) {
            List dependencies = permissionNode.getDependencies(permission);
            if (permission.getName().startsWith("perspective.read")) {
                Assert.assertEquals((long)dependencies.size(), (long)2L);
                continue;
            }
            Assert.assertNull((Object)dependencies);
        }
    }
}

