/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.authz;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.uberfire.client.authz.PerspectiveAction;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.mvp.WorkbenchEditorActivity;
import org.uberfire.client.resources.i18n.PermissionTreeI18n;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.client.authz.tree.LoadCallback;
import org.uberfire.security.client.authz.tree.LoadOptions;
import org.uberfire.security.client.authz.tree.PermissionNode;
import org.uberfire.security.client.authz.tree.PermissionTreeProvider;
import org.uberfire.security.client.authz.tree.impl.PermissionLeafNode;
import org.uberfire.security.client.authz.tree.impl.PermissionResourceNode;
import org.uberfire.workbench.model.ActivityResourceType;

@ApplicationScoped
public class EditorTreeProvider
implements PermissionTreeProvider {
    private ActivityBeansCache activityBeansCache;
    private PermissionManager permissionManager;
    private PermissionTreeI18n i18n;
    private String resourceName = null;
    private String rootNodeName = null;
    private int rootNodePosition = 0;
    private Set<RegisteredEditor> registeredEditors = new HashSet<RegisteredEditor>();

    public EditorTreeProvider() {
    }

    @Inject
    public EditorTreeProvider(ActivityBeansCache activityBeansCache, PermissionManager permissionManager, PermissionTreeI18n i18n) {
        this.activityBeansCache = activityBeansCache;
        this.permissionManager = permissionManager;
        this.i18n = i18n;
        this.resourceName = i18n.editorResourceName();
        this.rootNodeName = i18n.editorsNodeName();
    }

    public PermissionNode buildRootNode() {
        PermissionResourceNode rootNode = new PermissionResourceNode(this.resourceName, (PermissionTreeProvider)this);
        rootNode.setNodeName(this.rootNodeName);
        rootNode.setPositionInTree(this.rootNodePosition);
        rootNode.setNodeFullName(this.i18n.editorsNodeHelp());
        rootNode.addPermission(this.newPermission(PerspectiveAction.READ), this.i18n.editorRead());
        return rootNode;
    }

    public void loadChildren(PermissionNode parent, LoadOptions options, LoadCallback callback) {
        if (parent.getNodeName().equals(this.rootNodeName)) {
            callback.afterLoad(this.buildEditorNodes(options));
        }
    }

    public int getRootNodePosition() {
        return this.rootNodePosition;
    }

    public void setRootNodePosition(int rootNodePosition) {
        this.rootNodePosition = rootNodePosition;
    }

    public void registerEditor(String editorId, String editorName) {
        SyncBeanDef<Activity> editorBeanDef = this.activityBeansCache.getActivity(editorId);
        if (editorBeanDef != null) {
            WorkbenchEditorActivity editor = (WorkbenchEditorActivity)editorBeanDef.getInstance();
            this.registeredEditors.add(new RegisteredEditor(editorId, editorName, editor));
        }
    }

    private Permission newPermission(ResourceAction action) {
        return this.permissionManager.createPermission((ResourceType)ActivityResourceType.EDITOR, action, true);
    }

    private Permission newPermission(Resource resource, ResourceAction action) {
        return this.permissionManager.createPermission(resource, action, true);
    }

    private List<PermissionNode> buildEditorNodes(LoadOptions options) {
        ArrayList<PermissionNode> nodes = new ArrayList<PermissionNode>();
        this.registeredEditors.stream().filter(e -> this.match((RegisteredEditor)e, options)).forEach(e -> nodes.add(this.toEditorNode((RegisteredEditor)e)));
        int max = options.getMaxNodes();
        return max > 0 && max < nodes.size() ? nodes.subList(0, max) : nodes;
    }

    private PermissionNode toEditorNode(RegisteredEditor editor) {
        PermissionLeafNode node = new PermissionLeafNode();
        node.setNodeName(editor.editorName);
        Permission readPermission = this.newPermission((Resource)editor.activity, PerspectiveAction.READ);
        node.addPermission(readPermission, this.i18n.editorRead());
        return node;
    }

    private boolean match(RegisteredEditor editor, LoadOptions options) {
        String editorName;
        String identifier = editor.editorId;
        String namePattern = options.getNodeNamePattern();
        Collection includedIds = options.getResourceIds();
        if (includedIds != null && !includedIds.isEmpty() && includedIds.contains(identifier)) {
            return true;
        }
        return namePattern != null && (editorName = editor.editorName).toLowerCase().contains(namePattern.toLowerCase());
    }

    private class RegisteredEditor {
        private String editorId;
        private String editorName;
        private WorkbenchEditorActivity activity;

        public RegisteredEditor(String editorId, String editorName, WorkbenchEditorActivity activity) {
            this.editorId = editorId;
            this.editorName = editorName;
            this.activity = activity;
        }
    }
}

